.\" $Id: sane-hp_rts88xx.man,v 1.2 2004/22/10 10:35:31 jh Exp $
.TH sane-hp_rts88xx 5 "22 Oct 2004"
.IX sane-hp_rts88xx

.SH NAME
sane-hp_rts88xx - SANE backend for scanners based on the RTS8891 chipset.

.SH DESCRIPTION
The
.B sane-hp_rts88xx
implements a SANE (Scanner Access Now Easy) backend that
provides access to RTS8891 chipset based scanners. This backend will try to support
the following models:

MANUFACTURER:    MODEL:         USB ID:
.br
---------------  --------------  ---------
.br
Hewlett-Packard  Scanjet 4400c   03F0-0705
.br
Hewlett-Packard  Scanjet 4470c   03F0-0805
.br
Hewlett-Packard  Scanjet 3500C   03F0-2205
.br
Hewlett-Packard  Scanjet 3530c   03F0-2005
.br
Hewlett-Packard  Scanjet 3570c   03F0-2005
.br
.PP
.br

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I special
.RE
.PP
Where
.I special
is a path-name for the special device that corresponds to a USB scanner.
With GNU/Linux systems, such a device name could be
.I /dev/usb/scanner0
or
.IR /dev/usbscanner1 ,
for example.


.SH CONFIGURATION
The
.I hp_rts88xx.conf
file contains the device name that correspond to the hp44x0c
scanner.  Empty lines and lines starting with a hash mark (#) are
ignored.
.PP
A sample configuration file is shown below:
.PP
.RS
# Comment
.br
/dev/usbscanner
# option_CCD
# CCD0 or CCD1 allowed
# if you receive a black image, change it to CCD1
option CCD0
.RE
.PP
The first line is ignored. The second line is the device filename to use
in order to access the hp44x0c Scanner. If no device is given, the
backend will use libUSB.

.SH FILES
.TP
.I @CONFIGDIR@/hp_rts88xx.conf
The backend configuration file (see also description of SANE_CONFIG_DIR below).

.TP
.I @LIBDIR@/libsane-hp_rts88xx.a
The static library implementing this backend.

.TP
.I @LIBDIR@/libsane-hp_rts88xx.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT

.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP

.SH "SEE ALSO"
sane(7), sane\-usb(5)
.br
http://hp44x0backend.sourceforge.net
.SH AUTHOR
Johannes Hub <johanneshub@t-online.det>
