#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

#!/bin/sh
# the next line restarts using wish
# exec wish8.4 "$0" "$@"

# options
option add "*Entry*BorderWidth" 1
option add "*Scale*BorderWidth" 1
option add "*Radiobutton*BorderWidth" 1
option add "*Checkbutton*BorderWidth" 1
option add "*Scrollbar*BorderWidth" 1

# debug level
set debug(tcl,events) 0
set debug(tcl,update) 0
set debug(tcl,idletasks) 0
set debug(tcl,layout) 0
set debug(tcl,info) 0
set debug(tcl,watch) 0
set debug(tcl,hv) 0
set debug(tcl,grid) 0
set debug(tcl,http) 0
set debug(tcl,ftp) 0

set debug(saotk,ast) 0
set debug(saotk,mosaic) 0
set debug(saotk,parser) 0
set debug(saotk,perf) 0
set debug(saotk,wcs) 0
set debug(saotk,bin) 0
set debug(saotk,gz) 0
set debug(saotk,rgb) 0

set debug(iis) 0

# we don't want to see any error messages if xpa is not available
set env(XPA_VERBOSITY) 0

# source other scripts
# we do it this way because mktclapp does not implement package require
# package DS9 1.0
source source.tcl

# other tcl packages
if {$tcl_platform(platform) != "windows"} {
    source ../lib/tcl8.4/http2.5/http.tcl
    source ../lib/tcllib1.6/base64/base64.tcl
    source ../lib/tcllib1.6/log/log.tcl
    source ../lib/tcllib1.6/ftp/ftp.tcl
} else {
    source C:/cygwin/home/joye/saods9/lib/tcl8.4/http2.5/http.tcl
    source C:/cygwin/home/joye/saods9/lib/tcllib1.6/base64/base64.tcl
    source C:/cygwin/home/joye/saods9/lib/tcllib1.6/log/log.tcl
    source C:/cygwin/home/joye/saods9/lib/tcllib1.6/ftp/ftp.tcl
}

# required packages
package require http
package require base64
package require ftp

#package require Saoast
package require BLT
package require Tktable
package require checkdns
package require saotk
package require Tkhtml
package require tclxpa
package require iis
package require tkmpeg
package require img::base
package require img::jpeg
package require img::tiff
package require img::png
package require img::gif
package require img::ppm
package require img::bmp
package require img::xbm
package require img::window

# we need this after BLT is loaded
# neede for BLT_ZoomStack
if {$tcl_platform(platform) != "windows"} {
    source ../lib/blt2.4/graph.tcl
} else {
    source C:/cygwin/home/joye/saods9/lib/blt2.4/graph.tcl
}

# let's start
set ds9(init) 1

# Set Application Name
if {$tcl_platform(platform) != "windows"} {
    if {"$argv0"=="ds9.tcl"} {
	set ds9(app) ds9
    } else {
	set ds9(app) [file tail $argv0]
    }
} else {
    set ds9(app) ds9
}

tk appname $ds9(app)
set ds9(title) "$ds9(app)"
set ds9(version) "4.0b7"

# First, look for help quest
InitHelp
ProcessHelp

# ds9 Variables
# General Note:
# ds9(frames) contains list of all frames
# ds9(active) contains list of active (show) frames
# active(<framename>) contains status show/hide for framename
# slave(<framename>) contains list of frames that are slaves to framename
# master(<framename>) contains the name of the master frame of framename

# main component names
set ds9(top) .
set ds9(mb) .mb
set ds9(main) {}
set ds9(image) {}
set ds9(canvas) {}
set ds9(panel) {}
set ds9(info) {}
set ds9(panner) {}
set ds9(magnifier) {}
set ds9(buttons) {}
set ds9(graph,sp) {}
set ds9(graph,horz) {}
set ds9(graph,vert) {}

set ds9(visual) {}
set ds9(depth) 8
set ds9(frames) {}
set ds9(active) {}
set ds9(lock) 0
set ds9(next) {}
set ds9(language) english
set ds9(mode) pointer
if {$tcl_platform(platform)!= "windows"} {
    set ds9(dialog) motif
} else {
    set ds9(dialog) native
}
set ds9(display,mode) single
set ds9(display,user) single
set ds9(cursor) 1
set ds9(automarker) 1
set ds9(amp,det) 0

set ds9(mosaic,fast) 1
set ds9(nan,color) white
set ds9(bg,color) white

set ds9(xpa) 1
set ds9(xpa,tcl) 0
set ds9(xpa,ptr) 0
set ds9(xpa,idletasks) 1

set ds9(b1) 0
set ds9(b2) 0
set ds9(b3) 0

set ds9(sb1) 0
set ds9(sb2) 0
set ds9(sb3) 0

set ds9(cb1) 0
set ds9(cb2) 0
set ds9(cb3) 0

set ds9(csb1) 0
set ds9(csb2) 0
set ds9(csb3) 0

set ds9(internalpad) 2
set ds9(freeze) 0

set ds9(imexam) 0
set ds9(imexam,frame) {}
set ds9(imexam,x) {}
set ds9(imexam,y) {}

# external analysis and file formats
set ds9(ext,file) ".$ds9(app).fil"
set ds9(ext,alt) ".$ds9(app).file"
set ds9(analysis,file) ".$ds9(app).ans"
set ds9(analysis,alt) ".$ds9(app).analysis"
set ds9(analysis,user) {}
set ds9(analysis,user2) {}
set ds9(analysis,user3) {}
set ds9(analysis,user4) {}

# temp directory
if {$tcl_platform(platform) != "windows"} {
    set ds9(tmpdir) "/tmp"
} else {
    set ds9(tmpdir) "C:/WINDOWS/Temp"
}

# View Variables
set view(layout) horizontal
set view(info) 1
set view(panner) 1
set view(magnifier) 1
set view(buttons) 1
set view(colorbar) 1
set view(colorbar,next) 1
set view(graph,horz) 0
set view(graph,vert) 0

set view(info,filename) 1
set view(info,object) 1
set view(info,minmax) 0
set view(info,wcs) 1
foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
    set "view(info,wcs$l)" 0
}
set view(info,detector) 0
set view(info,amplifier) 0
set view(info,physical) 1
set view(info,image) 1
set view(info,frame) 1

# Info Variables
set info(row) -1

# fits dialog box
set fitsfbox(file)      {}
set fitsfbox(directory) {}
set fitsfbox(types) {
    {"Fits files"              *.fits}
    {"Fits files"              *.fts }
    {"Fits files"              *.fit }
    {"Fits files"              *.FIT }
    {"Compressed FITS files"   *.fitz }
    {"Compressed FITS files"   *.fits.gz }
    {"Compressed FITS files"   *.fits.Z }
    {"FITS files"              *.ds }
    {"All files"               *}
}
set fitsfbox(dirslist)  {}
set fitsfbox(loadtype)  {}
set fitsfbox(pattern)   1

set fitsvarfbox(file)      {}
set fitsvarfbox(directory) {}
set fitsvarfbox(types) {
    {"Fits files"              *.fits }
    {"Fits files"              *.fts }
    {"Fits files"              *.fit }
    {"Compressed FITS files"   *.fitz }
    {"Compressed FITS files"   *.fits.gz }
    {"Compressed FITS files"   *.fits.Z }
    {"FITS files"              *.ds }
    {"All files"               *}
}
set fitsvarfbox(dirslist)  {}
set fitsvarfbox(loadtype)  {}
set fitsvarfbox(pattern)   0

set arrayfbox(file)      {}
set arrayfbox(directory) {}
set arrayfbox(types) {
    {"Array files"   *.arr}
    {"All files"     *}
}
set arrayfbox(dirslist)  {}
set arrayfbox(loadtype)  {}
set arrayfbox(pattern)   1

# Internal file formats
set ds9(fileProcs) {Stdin ExternalFits CompressFits PackFits GzipFits FTZFits}

# Pixel Table Variables
set pixel(top) .pixel
set pixel(mb) .pixelmb
set pixel(view) 0
set pixel(size) 5
set pixel(maxsize) 9
set pixel(copy) {}

set pixelfbox(file)      {ds9.pix}
set pixelfbox(directory) {}
set pixelfbox(types) {
    {"Pixel Table files"   *.pix}
    {"All files"           *}
}
set pixelfbox(dirslist)  {}
set pixelfbox(loadtype)  {}
set pixelfbox(pattern)   0

# Cursor Variables
set cursor(save) {}
set cursor(count) 0
set cursor(id) 0
set cursor(timer) 0
set cursor(timer,abort) 0

# Crosshair Variables
set crosshair(lock) none

# Menu Variables
set menu(tearoff) 1
set menu(selectcolor) red
set menu(size,analysis) 27
set menu(size,arch) 24

# Frame Variables
set current(frame) {}
set current(colorbar) {}
set current(cursor) {}

set current(zoom) { 1 1 }
set current(rotate) 0
set current(orient) none

set current(rgb) red

blt::vector create histX histY

# RGB Variables
set rgb(red) 1
set rgb(green) 1
set rgb(blue) 1
set rgb(system) wcs
set rgb(lock,scale) 0
set rgb(lock,bin) 0
set rgb(lock,colorbar) 0

set rgb(top) .rgb
set rgb(mb) .rgbmb

# MinMax Variables
set minmax(mode) auto
set minmax(sample) 25

# Scale Variables
set scale(top) .scale
set scale(mb) .scalemb
set scale(type) linear
set scale(mode) minmax
set scale(scope) local
set scale(usermin) 1
set scale(usermax) 100
set scale(datasec) 1
set scale(xaxis) full
set scale(yaxis) log
set scale(preserve) 0

# PanZoom Variables
set panzoom(top) .pz
set panzoom(mb) .pzmb
set panzoom(system) image
set panzoom(sky) fk5
set panzoom(skyformat) sexagesimal
set panzoom(mode) click
set panzoom(preserve) 0
set panzoom(state) 1
set panzoom(last) {0 0}
set panzoom(speed) 512
set panzoom(x) 0

# Group Variablables
set group(top) .grp
set group(mb) .grpmb

# Marker Variables
set marker(copy) {}
set marker(show) 1
set marker(shape) circle
set marker(color) green
set marker(width) 1
set marker(edit) 1
set marker(move) 1
set marker(rotate) 1
set marker(delete) 1
set marker(fixed) 0
set marker(include) 1
set marker(source) 1
set marker(font) helvetica
set marker(font,size) 10
set marker(font,style) normal
set marker(preserve) 0
set marker(format) ds9
set marker(system) physical
set marker(sky) fk5
set marker(skyformat) degrees
set marker(strip) 0
set marker(wcs) 0
set marker(maxdialog) 48

# Default Dialog
set marker(dialog,system) physical
set marker(dialog,sky) fk5
set marker(dialog,skyformat) degrees
set marker(dialog,dist,system) physical
set marker(dialog,dist,format) degrees

# Default Marker Variables
set marker(circle,radius) 20

set marker(annulus,inner) 15
set marker(annulus,outer) 30
set marker(annulus,annuli) 1

set marker(panda,inner) 15
set marker(panda,outer) 30
set marker(panda,annuli) 1
set marker(panda,ang1) 0
set marker(panda,ang2) 360
set marker(panda,angnum) 4

set marker(ellipse,radius1) 40
set marker(ellipse,radius2) 20

set marker(ellipseannulus,radius1) 40
set marker(ellipseannulus,radius2) 20
set marker(ellipseannulus,radius3) 60
set marker(ellipseannulus,annuli) 1

set marker(epanda,radius1) 40
set marker(epanda,radius2) 20
set marker(epanda,radius3) 60
set marker(epanda,annuli) 1
set marker(epanda,ang1) 0
set marker(epanda,ang2) 360
set marker(epanda,angnum) 4

set marker(box,radius1) 80
set marker(box,radius2) 40

set marker(boxannulus,radius1) 80
set marker(boxannulus,radius2) 40
set marker(boxannulus,radius3) 120
set marker(boxannulus,annuli) 1

set marker(bpanda,radius1) 80
set marker(bpanda,radius2) 40
set marker(bpanda,radius3) 120
set marker(bpanda,annuli) 1
set marker(bpanda,ang1) 0
set marker(bpanda,ang2) 360
set marker(bpanda,angnum) 4

set marker(polygon,width) 20
set marker(polygon,height) 20
set marker(projection,thick) 0
set marker(compass,radius) 40

set markerfbox(file)      {ds9.reg}
set markerfbox(directory) {}
set markerfbox(types) {
    {"Region files"   *.reg}
    {"All files"      *}
}
set markerfbox(dirslist)  {}
set markerfbox(loadtype)  {}
set markerfbox(pattern)   0

InitTemplates

set templatefbox(file)      {ds9.tpl}
set templatefbox(directory) {}
set templatefbox(types) {
    {"Region files"   *.tpl}
    {"All files"      *}
}
set templatefbox(dirslist)  {}
set templatefbox(loadtype)  {}
set templatefbox(pattern)   0

# WCS Variables
set wcs(align) 0
set wcs(align,system) wcs
set wcs(align,sky) fk5

set wcs(system) wcs
set wcs(sky) fk5
set wcs(skyformat) sexagesimal

# Colorbar Variables
set colorbar(top) .clrbar
set colorbar(mb) .clrbarmb
set colorbar(width) 512
set colorbar(height) 18
set colorbar(gap) 3

set colorbar(map) Grey
set colorbar(invert) 0
set colorbar(count) 1
set colorbar(button1) 9
set colorbar(button2) 18
set colorbar(lock) 0
set colorbar(private) false
set colorbar(lock) 0

set colorbar(frame) {}

set colorbar(speed) 512
set colorbar(mult) 10
set colorbar(area) 0
set colorbar(mode) center

set colorbarfbox(file)      {}
set colorbarfbox(directory) {}
set colorbarfbox(types) {
    {"SAO Colormap files"   *.sao}
    {"LUT Colormap files"   *.lut}
    {"All files"            *}
}
set colorbarfbox(dirslist)  {}
set colorbarfbox(loadtype)  {}
set colorbarfbox(pattern)   0

set contrastbiasfbox(file)      {ds9.cb}
set contrastbiasfbox(directory) {}
set contrastbiasfbox(types) {
    {"Contrast/Bias files"   *.cb}
    {"All files"            *}
}
set contrastbiasfbox(dirslist)  {}
set contrastbiasfbox(loadtype)  {}
set contrastbiasfbox(pattern)   0

# Display Coords Variables
set coord(value) 1
set coord(image) 1
set coord(physical) 0
set coord(amplifier) 0
set coord(detector) 0
set coord(wcs) 1
foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
    set "coord(wcs$l)" 0
}
set coord(sky) fk5
set coord(skyformat) sexagesimal

# Canvas Variables
set canvas(width) 512
set canvas(height) 464

# Panner Variables
set panner(size) 128

set panner(compass,image) 1
set panner(compass,wcs) 1
set panner(compass,wcs,system) wcs
set panner(compass,wcs,sky) fk5

# Magnifier Variables
set magnifier(size) 128
set magnifier(region) 1
set magnifier(cursor) 1
set magnifier(zoom) 4

# Graph Variables
set graph(size) 150
set graph(font) "*helvetica-medium-r-*-100-*"
set graph(x,min) 0
set graph(x,max) 10
set graph(y,min) 1
set graph(y,max) 100

set graph(sp,x) 40
set graph(sp,y) 15

set graph(horz,grid) 1
set graph(horz,log) false
blt::vector create graphHorzX graphHorzY

set graph(vert,grid) 1
set graph(vert,log) false
blt::vector create graphVertX graphVertY

# Printing Variables
if {$tcl_platform(platform)!= "windows"} {
    set ps(dest) printer
} else {
    set ps(dest) file
}
set ps(cmd) "lp"
set ps(filename) "ds9.ps"
set ps(color) rgb
set ps(color2) color
set ps(level) 2
set ps(resolution) 72

set ps(orient) portrait
set ps(scale) scaled
set ps(size) letter
set ps(width) 8.5
set ps(height) 11

set pssavfbox(file)      {}
set pssavfbox(directory) {}
set pssavfbox(types) {
    {"Postscript files"   *.ps}
    {"All files"          *}
}
set pssavfbox(dirslist)  {}
set pssavfbox(loadtype)  {}
set pssavfbox(pattern)   0

# Tile Variables
set tile(top) .tile
set tile(mb) .tilemb
set tile(mode) grid
set tile(grid,row) 10
set tile(grid,col) 10
set tile(grid,mode) automatic
set tile(grid,gap) 4

# Blink Variables
set blink(interval) 500
set blink(index) -1
set blink(id) 0

# FITS Bin Table Support
set bin(function) sum
set bin(factor) { 1 1 }
set bin(depth) 1
set bin(buffersize) 1024
set bin(top) .bl
set bin(mb) .blmb

# Data Cube Variables
set cube(top) .cube
set cube(mb) .cubemb
set cube(slice) 1
set cube(depth) 1
set cube(id) 0

# Smooth Variables
set smooth(top) .sm
set smooth(mb) .smmb
set smooth(view) 0
set smooth(function) gaussian
set smooth(radius) 3

# Contour Variables
set contour(top) .ct
set contour(mb) .ctmb
set contour(view) 0
set contour(color) green
set contour(width) 1
set contour(smooth) 4
set contour(levels) 5
set contour(scale) linear
set contour(method) block
set contour(low) {}
set contour(high) {}
set contour(copy) {}

set contourfbox(file)      {ds9.con}
set contourfbox(directory) {}
set contourfbox(types) {
    {"Contour files"   *.con}
    {"All files"       *}
}
set contourfbox(dirslist)  {}
set contourfbox(loadtype)  {}
set contourfbox(pattern)   0

set contourlevfbox(file)      {ds9.lev}
set contourlevfbox(directory) {}
set contourlevfbox(types) {
    {"Contour Level files"   *.lev}
    {"All files"             *}
}
set contourlevfbox(dirslist)  {}
set contourlevfbox(loadtype)  {}
set contourlevfbox(pattern)   0

# Coordinate Grid
set grid(top) .grid
set grid(mb) .gridmb
set grid(view) 0

set grid(system) wcs
set grid(sky) fk5
set grid(skyformat) sexagesimal

set grid(type) analysis
set grid(type,numlab) interior

set grid(grid) 1
set grid(grid,color) 4
set grid(grid,width) 0
set grid(grid,style) 0

set grid(axes) 1
set grid(axes,color) 2
set grid(axes,width) 0
set grid(axes,style) 0

set grid(tick) 1
set grid(tick,color) 1
set grid(tick,width) 0
set grid(tick,style) 0

set grid(border) 1
set grid(border,color) 4
set grid(border,width) 0
set grid(border,style) 0

set grid(labelling) interior
set grid(labelup) 0
set grid(edge,1) bottom
set grid(edge,2) left

set grid(numlab) 1
set grid(numlab,font) helvetica
set grid(numlab,style) bold
set grid(numlab,size) 10
set grid(numlab,color) 3
set grid(numlab,gap1) {}
set grid(numlab,gap2) {}

set grid(title) 1
set grid(title,text) {}
set grid(title,def) 1
set grid(title,gap) {}
set grid(title,font) helvetica
set grid(title,style) bold
set grid(title,size) 12
set grid(title,color) 0

set grid(textlab) 1
set grid(label1) {}
set grid(textlab,def1) 1
set grid(gap1) {}
set grid(gapunit1) {}
set grid(label2) {}
set grid(textlab,def2) 1
set grid(gap2) {}
set grid(gapunit2) {}
set grid(textlab,font) helvetica
set grid(textlab,style) bold
set grid(textlab,size) 10
set grid(textlab,color) 0
set grid(textlab,gap1) {}
set grid(textlab,gap2) {}

set gridfbox(file)      {ds9.grd}
set gridfbox(directory) {}
set gridfbox(types) {
    {"Grid files"   *.grd}
    {"All files"    *}
}
set gridfbox(dirslist)  {}
set gridfbox(loadtype)  {}
set gridfbox(pattern)   0

# Examine Variables
set examine(mode) new
set examine(zoom) 4

# IIS Variables
set iis(state) 0
set iis(ififo) "/dev/imt1i"
set iis(ofifo) "/dev/imt1o"
set iis(port) 5137
set iis(unix) "/tmp/.IMT%d"
set iis(width) 512
set iis(height) 512
set iis(x) -1
set iis(y) -1
set iis(frame) {}

# Name Resolution Variables
set nres(top) .nres
set nres(mb) .nresmb
set nres(nameserver) simbad-sao
set nres(system) wcs
set nres(sky) fk5
set nres(skyformat) degrees
set nres(name) {}
set nres(x) {}
set nres(y) {}
set nres(state) 0

# DSS Variables
set dss(top) .dss
set dss(mb) .dssmb
set dss(nameserver) simbad-sao
set dss(server) sao
set dss(system) wcs
set dss(sky) fk5
set dss(skyformat) sexagesimal
set dss(rformat) arcmin
set dss(name) {}
set dss(x) {}
set dss(y) {}
set dss(width) 15
set dss(height) 15
set dss(survey) dss
set dss(mode) new
set dss(save) 0
set dss(fn) {}
set dss(state) 0

set dssfbox(file)      {dss.fits}
set dssfbox(directory) {}
set dssfbox(types) {
    {"Fits files"              *.fits}
    {"Fits files"              *.fts }
    {"Fits files"              *.fit }
    {"Compressed FITS files"   *.fitz }
    {"Compressed FITS files"   *.fits.gz }
    {"Compressed FITS files"   *.fits.Z }
    {"All files"               *}
}
set dssfbox(dirslist)  {}
set dssfbox(loadtype)  {}
set dssfbox(pattern)   0

# 2MASS Variables
set 2mass(top) .2mass
set 2mass(mb) .2massmb
set 2mass(nameserver) simbad-sao
set 2mass(system) wcs
set 2mass(sky) fk5
set 2mass(skyformat) sexagesimal
set 2mass(rformat) arcsec
set 2mass(name) {}
set 2mass(x) {}
set 2mass(y) {}
set 2mass(radius) 900
set 2mass(survey) j
set 2mass(mode) new
set 2mass(save) 0
set 2mass(fn) {}
set 2mass(state) 0

set 2massfbox(file)      {2mass.fits}
set 2massfbox(directory) {}
set 2massfbox(types) {
    {"Fits files"              *.fits}
    {"Fits files"              *.fts }
    {"Fits files"              *.fit }
    {"Compressed FITS files"   *.fitz }
    {"Compressed FITS files"   *.fits.gz }
    {"Compressed FITS files"   *.fits.Z }
    {"All files"               *}
}
set 2massfbox(dirslist)  {}
set 2massfbox(loadtype)  {}
set 2massfbox(pattern)   0

# Catalog Variables
set cat(id) 0
set cat(nameserver) simbad-sao
set cat(server) sao
set cat(system) wcs
set cat(sky) fk5
set cat(skyformat) sexagesimal
set cat(rformat) arcmin

set cat(width) 15
set cat(height) 15
set cat(max) 2000

set cat(minrows) 20
set cat(mincols) 10

set cat(source) {}
set cat(words) {}
set cat(wave) {}
set cat(mission) {}
set cat(astro) {}

set cat(sym,shape) {circle point}
set cat(sym,color) green
set cat(sym,units) physical

# catalog db
set catfbox(file)      {ds9.cat}
set catfbox(directory) {}
set catfbox(types) {
    {"Catalog files"           *.cat}
    {"Catalog files"           *.rdb}
    {"All files"               *}
}
set catfbox(dirslist)  {}
set catfbox(loadtype)  {}
set catfbox(pattern)   0

# catalog filter
set catfltfbox(file)      {ds9.flt}
set catfltfbox(directory) {}
set catfltfbox(types) {
    {"Catalog Filter files"    *.flt}
    {"All files"               *}
}
set catfltfbox(dirslist)  {}
set catfltfbox(loadtype)  {}
set catfltfbox(pattern)   0

# catalog symbol editor
set catsym(minrows) 6
set catsym(mincols) 8

set catsymfbox(file)      {ds9.sym}
set catsymfbox(directory) {}
set catsymfbox(types) {
    {"Catalog Symbol files"    *.sym}
    {"All files"               *}
}
set catsymfbox(dirslist)  {}
set catsymfbox(loadtype)  {}
set catsymfbox(pattern)   0

# VO Variables
set vo(top) .vo
set vo(mb) .vomb
set vo(timeout) 10000
set vo(state) 0
set vo(server) {http://hea-www.harvard.edu/RD/vo/list.txt}
set vo(server,title) {}
set vo(server,host) {}
set vo(server,url) {}
set vo(server,button) {}
set vo(hv) 1

# Analysis Variables
set analysis(menu,count) 0
set analysis(menu,hmenu,count) 0
set analysis(menu,hmenu) {}
set analysis(bind,count) 0
set analysis(param,count) 0
set analysis(param,seq) 0
set analysis(log) 0

set analysisfbox(file)      {}
set analysisfbox(directory) {}
set analysisfbox(types) {
    {"Analysis files"   *.ans}
    {"All files"        *}
}
set analysisfbox(dirslist)  {}
set analysisfbox(loadtype)  {}
set analysisfbox(pattern)   0

set apdatafbox(file)      {ds9.dat}
set apdatafbox(directory) {}
set apdatafbox(types) {
    {"Plot Data files"   *.dat}
    {"All files"         *}
}

set apdatafbox(dirslist)  {}
set apdatafbox(loadtype)  {}
set apdatafbox(pattern)   0

set apconfigfbox(file)      {ds9.plt}
set apconfigfbox(directory) {}
set apconfigfbox(types) {
    {"Plot Config files"   *.plt}
    {"All files"           *}
}
set apconfigfbox(dirslist)  {}
set apconfigfbox(loadtype)  {}
set apconfigfbox(pattern)   0

# Text Variables
set text(search) {}

set textfbox(file)      {ds9.txt}
set textfbox(directory) {}
set textfbox(types) {
    {"Text files"   *.txt}
    {"All files"    *}
}
set textfbox(dirslist)  {}
set textfbox(loadtype)  {}
set textfbox(pattern)   0

# TCL Variables
set tclfbox(file)      {}
set tclfbox(directory) {}
set tclfbox(types) {
    {"TCL files"   *.tcl}
    {"All files"   *}
}
set tclfbox(dirslist)  {}
set tclfbox(loadtype)  {}
set tclfbox(pattern)   0

# HTTP Variables
set http(last) {}
set http(proxy) 0
set http(proxy,host) {}
set http(proxy,port) {}
set http(auth) 0
set http(auth,user) {}
set http(auth,passwd) {}

# HV Variables
set hv(timeout) 20000
set hv(incr) 0
foreach n {1 2 3 4} {
    set hv(archive,menu,$n) {}
    set hv(archive,url,$n) {}
}

set hvfitsfbox(file)      {hv.fits}
set hvfitsfbox(directory) {}
set hvfitsfbox(types) {
    {"Fits files"              *.fits}
    {"Fits files"              *.fts }
    {"Fits files"              *.fit }
    {"Compressed FITS files"   *.fitz }
    {"Compressed FITS files"   *.fits.gz }
    {"Compressed FITS files"   *.fits.Z }
    {"All files"               *}
}
set hvfitsfbox(dirslist)  {}
set hvfitsfbox(loadtype)  {}
set hvfitsfbox(pattern)   0

set hvhtmlfbox(file)      {}
set hvhtmlfbox(directory) {}
set hvhtmlfbox(types) {
    {"HTML files"   *.html}
    {"HTML files"   *.htm }
    {"All files"    *}
}
set hvhtmlfbox(dirslist)  {}
set hvhtmlfbox(loadtype)  {}
set hvhtmlfbox(pattern)   0

set hvformfbox(file)      {}
set hvformfbox(directory) {}
set hvformfbox(types) {
    {"All files"     *}
}
set hvformfbox(dirslist)  {}
set hvformfbox(loadtype)  {}
set hvformfbox(pattern)   0

set hvsavefbox(file)      {}
set hvsavefbox(directory) {}
set hvsavefbox(types) {
    {"All files"     *}
}
set hvsavefbox(dirslist)  {}
set hvsavefbox(loadtype)  {}
set hvsavefbox(pattern)   0

# SaveImage Variables
set saveimage(format) jpeg
set saveimage(base) "ds9"
set saveimage(jpeg,quality) 75
set saveimage(tiff,compression) none
set saveimage(mpeg,quality) 2

set saveimagefbox(file)      {}
set saveimagefbox(directory) {}
set saveimagefbox(types) {
    {"All files"    *}
}
set saveimagefbox(dirslist)  {}
set saveimagefbox(loadtype)  {}
set saveimagefbox(pattern)   0

# SaveFITS Variables
set savefitsfbox(file)      {ds9.fits}
set savefitsfbox(directory) {}
set savefitsfbox(types) {
    {"FITS files"   *.fits}
    {"All files"    *}
}
set savefitsfbox(dirslist)  {}
set savefitsfbox(loadtype)  {}
set savefitsfbox(pattern)   0

# SaveMPEG Variables
set savempeg(quality) 2

set savempegfbox(file)      {ds9.mpg}
set savempegfbox(directory) {}
set savempegfbox(types) {
    {"MPEG files"   *.mpg}
    {"All files"    *}
}
set savempegfbox(dirslist)  {}
set savempegfbox(loadtype)  {}
set savempegfbox(pattern)   0

# TmpDir
set tmpdirfbox(file)      {}
set tmpdirfbox(directory) {}
set tmpdirfbox(types) {
    {"All files"        *}
}
set tmpdirfbox(dirslist)  {}
set tmpdirfbox(loadtype)  {}
set tmpdirfbox(pattern)   0

# Save State Variables
set statefbox(file)      {save.ds9}
set statefbox(directory) {}
set statefbox(types) {
    {"DS9 State files"   *.ds9}
    {"All files"    *}
}
set statefbox(dirslist)  {}
set statefbox(loadtype)  {}
set statefbox(pattern)   0

# Plot Tool Variables
set ap(unique,id) 0
set ap(xpa) {}
set ap(tt) "ap"

# Preference Variables

set prefs(version) $ds9(version)

# init files
set prefs(file) "~/.$ds9(app).prf"
set prefs(file,alt) "~/.$ds9(app).prefs"
set prefs(file,local) "/usr/local/lib/$ds9(app).prf"
set prefs(file,opt)  "/opt/local/lib/$ds9(app).prf"
set prefs(startup) "~/.$ds9(app).ini"
set prefs(startup,alt) "~/.$ds9(app)"

if {$tcl_platform(platform) == "windows"} {
    set prefs(file) ".$ds9(app).prf"
    set prefs(file,alt) "$ds9(app).prf"
    set prefs(startup) ".$ds9(app).ini"
    set prefs(startup,alt) "$ds9(app).ini"
}

set prefs(font) default
set prefs(font,size) 10
set prefs(font,style) normal
set prefs(wcs,system) $wcs(system)
set prefs(wcs,sky) $wcs(sky)
set prefs(wcs,skyformat) $wcs(skyformat)
set prefs(ds9,mode) $ds9(mode)
set prefs(blink,interval) $blink(interval)
set prefs(tile,mode) $tile(mode)
set prefs(bin,function) $bin(function)
set prefs(bin,factor) $bin(factor)
set prefs(bin,depth) $bin(depth)
set prefs(bin,buffersize) $bin(buffersize)
set prefs(wcs,align) $wcs(align)
set prefs(wcs,align,system) $wcs(align,system)
set prefs(wcs,align,sky) $wcs(align,sky)
set prefs(zoom) $current(zoom)
set prefs(orient) $current(orient)
set prefs(rotate) $current(rotate)
set prefs(minmax,mode) $minmax(mode)
set prefs(minmax,sample) $minmax(sample)
set prefs(scale) $scale(type)
set prefs(scale,mode) $scale(mode)
set prefs(scale,scope) $scale(scope)
set prefs(scale,datasec) $scale(datasec)
set prefs(colorbar,map) $colorbar(map)
set prefs(colorbar,invert) $colorbar(invert)
set prefs(contour,method) $contour(method)
set prefs(contour,color) $contour(color)
set prefs(contour,width) $contour(width)
set prefs(smooth,function) $smooth(function)
set prefs(smooth,radius) $smooth(radius)
set prefs(analysis,log) $analysis(log)
set prefs(analysis,user) $ds9(analysis,user)
set prefs(analysis,user2) $ds9(analysis,user2)
set prefs(analysis,user3) $ds9(analysis,user3)
set prefs(analysis,user4) $ds9(analysis,user4)

# View Prefs
set prefs(view,layout) $view(layout)
set prefs(view,info) $view(info)
set prefs(view,panner) $view(panner)
set prefs(view,magnifier) $view(magnifier)
set prefs(view,buttons) $view(buttons)
set prefs(view,colorbar) $view(colorbar)
set prefs(view,graph,horz) $view(graph,horz)
set prefs(view,graph,vert) $view(graph,vert)

set prefs(view,info,filename) 1
set prefs(view,info,object) 0
set prefs(view,info,minmax) 0
set prefs(view,info,wcs) 1
foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
    set "prefs(view,info,wcs$l)" 0
}
set prefs(view,info,detector) 0
set prefs(view,info,amplifier) 0
set prefs(view,info,physical) 1
set prefs(view,info,image) 1
set prefs(view,info,frame) 1

# Marker Prefs
set prefs(marker,shape) $marker(shape)
set prefs(marker,color) $marker(color)
set prefs(marker,width) $marker(width)
set prefs(marker,edit) $marker(edit)
set prefs(marker,move) $marker(move)
set prefs(marker,rotate) $marker(rotate)
set prefs(marker,delete) $marker(delete)
set prefs(marker,fixed) $marker(fixed)
set prefs(marker,include) $marker(include)
set prefs(marker,source) $marker(source)
set prefs(marker,font) $marker(font)
set prefs(marker,font,size) $marker(font,size)
set prefs(marker,font,style) $marker(font,style)
set prefs(marker,format) $marker(format)
set prefs(marker,strip) $marker(strip)
set prefs(marker,wcs) $marker(wcs)
set prefs(marker,system) $marker(system)
set prefs(marker,sky) $marker(sky)
set prefs(marker,skyformat) $marker(skyformat)

# Print Prefs
set prefs(ps,dest) $ps(dest)
set prefs(ps,cmd) $ps(cmd)
set prefs(ps,filename) $ps(filename)
set prefs(ps,color) $ps(color)
set prefs(ps,color2) $ps(color2)
set prefs(ps,level) $ps(level)
set prefs(ps,resolution) $ps(resolution)

# Page Setup Prefs
set prefs(ps,orient) $ps(orient)
set prefs(ps,scale) $ps(scale)
set prefs(ps,size) $ps(size)
set prefs(ps,width) $ps(width)
set prefs(ps,height) $ps(height)

# VO Prefs
set prefs(vo,hv) $vo(hv)

# Analysis Plot prefs
set prefs(ap,grid) 1
set prefs(ap,grid,log) linearlinear

set prefs(ap,discrete) 0
set prefs(ap,discrete,symbol) circle
set prefs(ap,discrete,color) red

set prefs(ap,linear) 1
set prefs(ap,linear,width) 1
set prefs(ap,linear,color) black
set prefs(ap,linear,dash) " "

set prefs(ap,step) 0
set prefs(ap,step,width) 1
set prefs(ap,step,color) black
set prefs(ap,step,dash) " "

set prefs(ap,quadratic) 0
set prefs(ap,quadratic,width) 1
set prefs(ap,quadratic,color) black
set prefs(ap,quadratic,dash) " "

set prefs(ap,error) 1
set prefs(ap,error,width) 1
set prefs(ap,error,color) red
set prefs(ap,error,style) 0

set prefs(ap,titleFont) helvetica
set prefs(ap,titleSize) 12
set prefs(ap,titleStyle) normal

set prefs(ap,textlabFont) helvetica
set prefs(ap,textlabSize) 10
set prefs(ap,textlabStyle) normal

set prefs(ap,numlabFont) helvetica
set prefs(ap,numlabSize) 10
set prefs(ap,numlabStyle) normal

# set default font
if {$prefs(font) != "default"} {
    option add *font "$prefs(font) $prefs(font,size) $prefs(font,style)"
}

# Load any preferences here, before we do any real work
LoadPrefs

# Toplevel-- Start here.
# We want to withdraw the window til everything is ready to go

wm withdraw $ds9(top)

set t "SAOImage $ds9(title)"
wm title $ds9(top) "$t"
wm iconname $ds9(top) "$t"
wm protocol $ds9(top) WM_DELETE_WINDOW QuitDS9
unset t

# This solves this problem:
# 1. tk no longer changes the vert size, thus generating two update sequences
# wm geometry $ds9(top) 750x749
# wm minsize $ds9(top) 640 480
$ds9(top) configure -menu $ds9(mb)

# we need to set certain variables for color before anything else.
# also, set the title
ProcessCommandLineFirst

set ds9(visual) [winfo visual .]
set ds9(depth) [winfo depth .]

if {$tcl_platform(platform)== "windows"} {
    if {$ds9(depth)==32} {
	set ds9(depth) 24
    }
}

if {$ds9(depth)==15} {
    set ds9(depth) 16
}

switch -- $ds9(visual)$ds9(depth) {
    pseudocolor8 {}
    truecolor8 {}
    truecolor16 {}
    truecolor24 {}
    default {BadVisualError}
}

# create our main frame
set ds9(main) [frame ${ds9(top)}ds9]
pack $ds9(main) -fill both -expand true

# Create image canvas
set ds9(image) [frame $ds9(main).f -bd 2 -relief groove]
set ds9(canvas) [canvas $ds9(image).c \
		     -width $canvas(width) -height $canvas(height) \
		     -highlightthickness 0 -insertofftime 0]

# Create Colorbar-- Create this first, so in case of a private colormap,
# gui colors will be allocated in the new colormap, not the default colormap
CreateColorbar

# Create other parts of the display
CreateMenuBar
CreateInfoPanel
CreateButtons
CreateGraphs

# Make sure that the wm knows when to swap in the colormap (if needed)
wm colormapwindows . "$ds9(main) $ds9(canvas)"

# Initialize the display
InitColorbar
InitPanner

# Set our current state of things
CreateColorMenus
ChangeMode
LayoutView

# ok, CreateFrame needs an update
RealizeDS9
CreateFrame

# ok, ready to show the window
wm deiconify $ds9(top)

# we do this now, so configure events doesn't run LayoutFrames
InitCanvas

# Init external File Formats
# we want this before processing the command line
InitExternalFile

# Init analysis file formats
InitAnalysisFile

# Configure HTTP
ConfigHTTP

# and process any command line items
# we want to see something before any fits files are loaded
ProcessCommandLine

# Initialize IIS
# after command line options to set port/fifo/unix...
catch {IISInit}

# Initialize XPA
if {$ds9(xpa)} {
    if {[info exists env(XPA_METHOD)]} {
	if {$env(XPA_METHOD) == "local"} {
	    catch {InitXPA}
	} else {
	    if {![checkdns {} 5]} {
		catch {InitXPA}
	    } else {
		Error "XPA: unable to verify hostname"
	    }
	}
    } else {
	if {![checkdns {} 5]} {
	    catch {InitXPA}
	} else {
	    Error "XPA: unable to verify hostname"
	}
    }
}

# and finally, process any command line options that are dependant on xpa
ProcessCommandLineXPA

# Load other user tcl code
if {[file exists "$prefs(startup)"]} {
    catch {source "$prefs(startup)"}
} elseif {[file exists "$prefs(startup,alt)"]} {
    catch {source "$prefs(startup,alt)"}
}

# and finally, execute code that prefs may have changed
UpdatePrefsMenu

ChangeImageCompass
ChangeWCSCompass

ChangeMagnifierRegion
ChangeMagnifierCursor
MagnifierZoomTo

# do we have an old prefs file?
CheckPrefs

# ok, we're done
set ds9(init) 0
