#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc LineDialog {frame id} {
    global menu
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # variables
    set arrows [$frame get marker $id line arrow]

    # base
    MarkerBaseLineDialog $frame $id 275 225

    # Arrows
    checkbutton $w.ref.f.p1arrow -variable marker($frame,$id,p1arrow) \
	-text Arrow -selectcolor $menu(selectcolor) \
	-command "LineArrow $frame $id"
    checkbutton $w.ref.f.p2arrow -variable marker($frame,$id,p2arrow) \
	-text Arrow -selectcolor $menu(selectcolor) \
	-command "LineArrow $frame $id"
    grid $w.ref.f.p1arrow -row 0 -column 4 -padx 4 -sticky w
    grid $w.ref.f.p2arrow -row 1 -column 4 -padx 4 -sticky w
}

# actions

proc LineClose {frame id} {
    MarkerBaseLineClose $frame $id
}

proc LineApply {frame id} {
    global marker

    $frame marker $id line point \
	$marker($frame,$id,system) $marker($frame,$id,sky) \
	$marker($frame,$id,x) $marker($frame,$id,y) \
	$marker($frame,$id,x2) $marker($frame,$id,y2)

    MarkerBaseLineApply $frame $id
}

proc LineArrow {frame id} {
    global marker
    
    $frame marker $id line arrow \
	$marker($frame,$id,p1arrow) $marker($frame,$id,p2arrow)
}

# callbacks

proc LineCoordCB {frame id} {
    MarkerBaseCoordCB $frame $id
    LineEditCB $frame $id
}

proc LineEditCB {frame id} {
    global marker

    MarkerBaseLineEditCB $frame $id

    set marker($frame,$id,dist) \
	[$frame get marker $id line length \
	     $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]

    set marker($frame,$id,angle) \
	[$frame get marker $id angle \
	     $marker($frame,$id,system) $marker($frame,$id,sky)]
}

proc LineDistCB {frame id} {
    global marker

    MarkerBaseDistCB $frame $id

    set marker($frame,$id,dist) \
	[$frame get marker $id line length \
	     $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
}


