// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __baseellipse_h__
#define __baseellipse_h__

#include "basemarker.h"

class BaseEllipse : public BaseMarker {
 private:
  void renderCircle(Drawable, const Matrix&);
  void renderEllipse(Drawable, const Matrix&);

  void psCircle(int);
  void psEllipse(int);
  void psEllipsePrep(double, double, double, double, Vector&);
  void psEllipseArc(double, double, Vector&);

 protected:
  virtual void render(Drawable, const Matrix&, RenderMode);
  virtual void updateHandles();
  virtual void newVertices();

 public:
  BaseEllipse(const BaseEllipse&);
  BaseEllipse(FrameBase* p, const Vector& ctr, 
	      double a,
	      const char* clr, int w, const char* f, const char* t, 
	      unsigned short prop, const char* c, 
	      const List<Tag>& tag, const List<CallBack>& cb);

  virtual Marker* dup() =0;
  int isIn(const Vector&);
  void ps(int);
};

#endif


