// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorscale_h__
#define __colorscale_h__

#include <string.h>

#include <tcl.h>
#include <X11/Xlib.h>

#define IISMIN 1
#define IISMAX 209
#define IISSIZE 209
#define IISCOLORS 200

class ColorScale {
protected:
  int size_;
  unsigned char* psColors_;  // rgb for ps
  unsigned short* psIndex_;  // index for ps
  unsigned char* colors_;    // for render

public:
  ColorScale(int);
  virtual ~ColorScale();

  int size() {return size_;}
  const unsigned char* psColors() {return psColors_;}
  const unsigned short* psIndex() {return psIndex_;}
  const unsigned char* colors() {return colors_;}
};

class LinearScale : public virtual ColorScale {
public:
  LinearScale(int, unsigned short*, unsigned char*, int);
};

class LogScale : public virtual ColorScale {
public:
  LogScale(int, unsigned short*, unsigned char*, int);
};

class SquaredScale : public virtual ColorScale {
public:
  SquaredScale(int, unsigned short*, unsigned char*, int);
};

class SqrtScale : public virtual ColorScale {
public:
  SqrtScale(int, unsigned short*, unsigned char*, int);
};

class IISScale : public virtual ColorScale {
 private:
  void setRGBColor(unsigned char*, const char*);

public:
  IISScale(unsigned short*, unsigned char*, int);
};

class HistEquScale : public virtual ColorScale {
public:
  HistEquScale(int, unsigned short*, unsigned char*, int, double*, int);
};

#endif
