// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __epanda_h__
#define __epanda_h__

#include "basepanda.h"
#include "baseellipse.h"

class Epanda : public BasePanda, public BaseEllipse {
 private:
  void updateHandles();
  void render(Drawable, const Matrix&, RenderMode);

  void listA(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listB(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);

 public:
  Epanda(const Epanda&);
  Epanda(FrameBase* p, const Vector& ctr, 
	 double a1, double a2, int an,
	 const Vector& r1, const Vector& r2, int rn,
	 double ang,
	 const char* clr, int wth, const char* fnt, const char* txt, 
	 unsigned short prop, const char* cmt, 
	 const List<Tag>& tg, const List<CallBack>& cb);

  Epanda(FrameBase* p, const Vector& ctr, 
	 int an, double* a,
	 int rn, Vector* r,
	 double ang,
	 const char* clr, int wth, const char* fnt, const char* txt, 
	 unsigned short prop, const char* cmt, 
	 const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new Epanda(*this);}
  void ps(int);

  void edit(const Vector&, int);
  void editEnd();

  int addAnnuli(const Vector&);
  int addAngles(const Vector&);
  void setAnglesAnnuli(double, double, int, Vector, Vector, int);
  void setAnglesAnnuli(const double*, int, const Vector*, int);
  void deleteAnglesAnnuli(int h);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
};

#endif
