/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.AssemblyName;
import ch.epfl.lamp.compiler.msil.CustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.Module;
import ch.epfl.lamp.compiler.msil.PEAssembly;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.Version;
import ch.epfl.lamp.compiler.msil.util.Table;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Assembly
extends CustomAttributeProvider {
    protected static final HashMap assemblies = new HashMap();
    public MethodInfo EntryPoint;
    public final String FullName;
    protected final AssemblyName assemblyName;
    protected Type[] types = null;
    private final HashMap modulesMap = new HashMap();
    private boolean initModules = true;

    public static Assembly LoadFrom(String string) {
        File file = new File(string);
        return Assembly.LoadFrom(file.getParentFile(), file.getName());
    }

    public static Assembly LoadFrom(File file, String string) {
        File file2;
        File file3 = null;
        PEFile pEFile = null;
        if (string.endsWith(".exe") || string.endsWith(".EXE") || string.endsWith(".dll") || string.endsWith(".DLL")) {
            file3 = new File(file, string);
            pEFile = Assembly.getPEFile(file3);
            string = string.substring(0, string.length() - 4);
        }
        File file4 = file2 = pEFile == null ? new File(file, string) : null;
        if (pEFile == null) {
            file3 = new File(file, string + ".dll");
            pEFile = Assembly.getPEFile(file3);
        }
        if (pEFile == null) {
            file3 = new File(file, string + ".DLL");
            pEFile = Assembly.getPEFile(file3);
        }
        if (pEFile == null && file2.exists()) {
            file3 = new File(file2, string + ".dll");
            pEFile = Assembly.getPEFile(file3);
        }
        if (pEFile == null && file2.exists()) {
            file3 = new File(file2, string + ".DLL");
            pEFile = Assembly.getPEFile(file3);
        }
        if (pEFile == null) {
            file3 = new File(file, string + ".exe");
            pEFile = Assembly.getPEFile(file3);
        }
        if (pEFile == null) {
            file3 = new File(file, string + ".EXE");
            pEFile = Assembly.getPEFile(file3);
        }
        if (pEFile == null && file2.exists()) {
            file3 = new File(file2, string + ".exe");
            pEFile = Assembly.getPEFile(file3);
        }
        if (pEFile == null && file2.exists()) {
            file3 = new File(file2, string + ".EXE");
            pEFile = Assembly.getPEFile(file3);
        }
        if (pEFile == null) {
            throw new RuntimeException("Cannot find assembly " + new File(file, string));
        }
        return Assembly.getPEAssembly(pEFile);
    }

    private static Assembly getPEAssembly(PEFile pEFile) {
        Table.AssemblyDef assemblyDef = pEFile.AssemblyDef;
        if (assemblyDef == null) {
            throw new RuntimeException("File " + pEFile + " does not contain a manifest");
        }
        assemblyDef.readRow(1);
        String string = pEFile.getString(assemblyDef.Name);
        Assembly assembly = (Assembly)assemblies.get(string);
        if (assembly != null) {
            return assembly;
        }
        AssemblyName assemblyName = new AssemblyName();
        assemblyName.Name = pEFile.getString(assemblyDef.Name);
        assemblyName.Version = new Version(assemblyDef.MajorVersion, assemblyDef.MinorVersion, assemblyDef.BuildNumber, assemblyDef.RevisionNumber);
        assemblyName.SetPublicKey(pEFile.getBlob(assemblyDef.PublicKey));
        return new PEAssembly(pEFile, assemblyName);
    }

    protected static PEFile getPEFile(File file) {
        PEFile pEFile = null;
        try {
            pEFile = new PEFile(file.getAbsolutePath());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return pEFile;
    }

    protected Assembly(AssemblyName assemblyName) {
        this.assemblyName = assemblyName;
        this.FullName = assemblyName.toString();
        assemblies.put(assemblyName.Name, this);
    }

    protected static Assembly getAssembly(String string) {
        return (Assembly)assemblies.get(string);
    }

    public File getFile() {
        throw new RuntimeException("Not supported");
    }

    public Module GetModule(String string) {
        this.initModules();
        return (Module)this.modulesMap.get(string);
    }

    public Module[] GetModules() {
        this.initModules();
        return this.modulesMap.values().toArray(new Module[this.modulesMap.size()]);
    }

    public Type GetType(String string) {
        this.initModules();
        Iterator iterator = this.modulesMap.values().iterator();
        Type type = null;
        while (type == null && iterator.hasNext()) {
            type = ((Module)iterator.next()).GetType(string);
        }
        return type;
    }

    public synchronized Type[] GetTypes() {
        if (this.types != null) {
            return (Type[])this.types.clone();
        }
        this.initModules();
        Iterator iterator = this.modulesMap.values().iterator();
        Type[] typeArray = ((Module)iterator.next()).GetTypes();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            Type[] typeArray2 = module.GetTypes();
            Type[] typeArray3 = typeArray;
            typeArray = new Type[typeArray3.length + typeArray2.length];
            System.arraycopy(typeArray3, 0, typeArray, 0, typeArray3.length);
            System.arraycopy(typeArray2, 0, typeArray, typeArray3.length, typeArray2.length);
        }
        this.types = typeArray;
        return (Type[])this.types.clone();
    }

    public AssemblyName GetName() {
        return this.assemblyName;
    }

    public String toString() {
        return this.FullName;
    }

    protected void addType(Type type) {
        Type.addType(type);
    }

    protected void addModule(String string, Module module) {
        this.modulesMap.put(string, module);
    }

    protected final void initModules() {
        if (this.initModules) {
            this.loadModules();
            this.initModules = false;
        }
    }

    protected abstract void loadModules();

    void dumpTypes() {
        Type[] typeArray = this.GetTypes();
        for (int i = 0; i < typeArray.length; ++i) {
            System.out.println(typeArray[i]);
        }
    }
}

