# Used and adapted the template at http://en.opensuse.org/SUSE_Build_Tutorial

Name: screenkast
Version: 0.1.3
Release: 1
Vendor: B²
License: GPL
Summary: A screen-recording program using the Instrudeo library.
Group: X11/KDE/Multimedia
Packager: Bram Biesbrouck <b@beligum.org>
BuildRoot:    %{_tmppath}/%{name}-%{version}-build
Source: %name-%{version}.tar.gz

%description
 Screen capturing program that records your screen-activities, supports commentboxes and exports to all video formats.
 It also acts as a client for the captorials.com website that enables you to share your captured tutorial with users around the world.

%prep
%setup
CFLAGS="$RPM_OPT_FLAGS"
CXXFLAGS="$RPM_OPT_FLAGS"

# source the standard build enviroment as defined in kdelibs3 package
. /etc/opt/kde3/common_options

# We need this on SuSe, should be fixed in svn trunk
LDFLAGS="$LDFLAGS -L/usr/X11R6/lib"

./configure $configkde --disable-final # --with-extra-includes=/home/beligum/libinstrudeo-0.1.3/src

%build
make

%install
iconv -f iso8859-1 -t utf-8 src/kvpnc.desktop > w && mv w src/kvpnc.desktop
# install all files into the BuildRoot
make DESTDIR=$RPM_BUILD_ROOT install
# updates the .desktop file. It applys additional translations and Categories for a 
# proper position in the KDE menu
%suse_update_desktop_file %name Recorder
# does find all localisation files and adds proper database attributes to them
%find_lang %name

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig
%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README
/opt/kde3/bin/isdvncviewer
/opt/kde3/bin/screenkast

/opt/kde3/lib/libisdvncauth.a

/opt/kde3/share/applications/kde/screenkast.desktop
/opt/kde3/share/apps/screenkast/screenkastui.rc

/opt/kde3/share/icons/hicolor/*/apps/screenkast.png

/opt/kde3/share/services/screenkast.desktop

/opt/kde3/share/doc/HTML/en/screenkast/*

%changelog


