/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#include <cstdio>
#include <cstdlib>
#include <iostream>

#include "srkplatformcombobox.h"

//-----CONSTRUCTORS-----
SRKPlatformComboBox::SRKPlatformComboBox(QWidget* parent, const char* name)
    : KComboBox(parent, name), childBox(NULL)
{
    connect(this, SIGNAL(activated(const QString&)), SLOT(slotActivated(const QString&)));
}

//-----DESTRUCTOR-----
SRKPlatformComboBox::~SRKPlatformComboBox()
{
    //delete all children if this box is deleted
    if (childBox!=NULL){
	delete childBox;
	childBox = NULL;
    }
}

//-----PUBLIC FUNCTIONS-----
SRKPlatformComboBox* SRKPlatformComboBox::getChildBox()
{
    return childBox;
}
void SRKPlatformComboBox::setChildBox(SRKPlatformComboBox* child)
{
    childBox = child;
}
void SRKPlatformComboBox::deleteChildBoxes()
{
    if (childBox){
	delete childBox;
	childBox = NULL;
    }
}
void SRKPlatformComboBox::addChoice(ISDWSPlatform* c)
{
    //Note: both lists are synchonizedly appended to
    platformList.push_back(c);

    if (c!=NULL) {
	this->insertItem(QString::fromUtf8(c->getTitle().data()));
    }
    else {
	this->insertItem("");
    }
}
void SRKPlatformComboBox::removeChoice(ISDWSPlatform* c)
{
    if (c!=NULL) {
	//search the platform
	vector<ISDWSPlatform*>::iterator iter;
	int index = 0;
	for (iter=platformList.begin(); iter!=platformList.end(); iter++, index++) {
	    if ((*iter)!=NULL && (*iter)->getId()==c->getId()) {
		break;
	    }
	}

	//if the iterator does not point to the end, the platform was found
	if (iter!=platformList.end()) {
	    this->removeItem(index);
	    platformList.erase(iter);
	}
    }
}
ISDWSPlatform* SRKPlatformComboBox::getCurrentSelection()
{
    //since both lists are synchronized, we can use the index for both
    int index = this->currentItem();
    return platformList[index];
}
void SRKPlatformComboBox::setCurrentSelection(ISDWSPlatform* c)
{
    if (c!=NULL) {
	QString title = QString::fromUtf8(c->getTitle().data());
	//if the item is available, it is selected, otherwise, no item is selected
	this->setCurrentItem(title);
	
	if (title==currentText()) {
	    emit activated(title, this);
	}
    }
}

//-----PROTECTED SLOTS-----
void SRKPlatformComboBox::slotActivated(const QString& s)
{
    emit activated(s, this);
}



