/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/


#ifndef SRKPREFDIALOG_H
#define SRKPREFDIALOG_H

#include "srkprefdialogbase.h"
#include "srkerror.h"

#define DEFAULT_WEBSERVICE_URL ""
#define DEFAULT_WEBSERVICE_USERNAME ""
#define DEFAULT_WEBSERVICE_PASSWORD ""

#define DEFAULT_SERVER_LOCATION "/usr/bin/vncserver"
#define DEFAULT_SERVER_MODE 2
#define DEFAULT_LAUNCH_SERVER_DISPLAY 1
#define DEFAULT_SERVER_X_RESOLUTION 800
#define DEFAULT_SERVER_Y_RESOLUTION 600
#define DEFAULT_EXISTING_SERVER_HOST "localhost"
#define DEFAULT_EXISTING_SERVER_DISPLAY 1

#define DEFAULT_ISD_VIEWER_LOCATION "/usr/bin/isdvncviewer"
#define DEFAULT_ISD_EXPORT_LOCATION "/usr/bin/isdexport"

#define DEFAULT_DEFAULT_COMMENT_DURATION 3000
#define DEFAULT_DEFAULT_COMMENT_OPACITY 50
#define DEFAULT_DEFAULT_COMMENT_WIDTH 300
#define DEFAULT_DEFAULT_COMMENT_HEIGHT 200
#define DEFAULT_DEFAULT_COMMENT_FILL_COLOR_RED 1.0
#define DEFAULT_DEFAULT_COMMENT_FILL_COLOR_GREEN 1.0
#define DEFAULT_DEFAULT_COMMENT_FILL_COLOR_BLUE 1.0
#define DEFAULT_DEFAULT_COMMENT_TEXT_COLOR_RED 0.0
#define DEFAULT_DEFAULT_COMMENT_TEXT_COLOR_GREEN 0.0
#define DEFAULT_DEFAULT_COMMENT_TEXT_COLOR_BLUE 0.0

class SRKPrefDialog : public SRKPrefDialogBase
{
  Q_OBJECT

public:
  enum VncServerMode {
      LAUNCH_NEW = 1,
      USE_EXISTING = 2
  };

  SRKPrefDialog(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  virtual ~SRKPrefDialog();

public slots:

protected:

protected slots:
  virtual void          reject();
  virtual void          accept();

};

#endif

