/***************************************************************************
                          editor_commands.cpp  -  description
                             -------------------
    begin                : Wed Oct 4 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "editor.h"


#define FIELDS_MAX 12

//to make it easier to understand! current note under cursor

// Cursor Stuff

int Pattern_Editor::GetLowerLimit() {

	int result;

	result=cursor_y-song->get_abs_row(cursor_y);

	return result;
}



int Pattern_Editor::GetUpperLimit() {

	int result;


	result=((cursor_y-song->get_abs_row(cursor_y))+song->get_pattern_length(song->get_abs_pattern(cursor_y)))-1;	


	return result;

}


int Pattern_Editor::GetInsertLimit() {

	int result;

	result=((cursor_y-song->get_abs_row(cursor_y))+song->get_pattern_length(song->get_abs_pattern(cursor_y)))-1;	

	return result;

}

void Pattern_Editor::cursor_step_up(int amount=1) {

	
	int limit=locked_to_pattern?GetLowerLimit():0;
	int cursor_pat=get_cursor_pattern();


	cursor_y-=amount;
	if (cursor_y<limit) cursor_y=limit;
	shift_selection_update();

	if (get_cursor_pattern()!=cursor_pat) {

		set_flag_redraw_all();

	} else {

		set_flag_redraw_row();
	}

}

void Pattern_Editor::cursor_step_down(int amount=1) {

        int limit;

	int cursor_pat=get_cursor_pattern();

	limit=locked_to_pattern?GetUpperLimit():song->get_abs_height();

	cursor_y+=amount;
	if (cursor_y>limit) cursor_y=limit;

        shift_selection_update();

	if (get_cursor_pattern()!=cursor_pat) {

		set_flag_redraw_all();

	} else {

		set_flag_redraw_row();
	}

}

void Pattern_Editor::cursor_move_up(int amount) {

        int limit;

	limit=GetLowerLimit();

	cursor_y-=amount;
	if (cursor_y<limit) cursor_y=limit;
	shift_selection_update();

	set_flag_redraw_row();

}

void Pattern_Editor::cursor_move_down(int amount) {

        int limit;

	limit=GetUpperLimit();

	cursor_y+=amount;
	if (cursor_y>limit) cursor_y=limit;

        shift_selection_update();
	set_flag_redraw_row();
}

void Pattern_Editor::cursor_move_left(int amount) {

	if (get_cursor_column()==0)
		 midi_input.clear(); //switched track!
	 
	cursor_x-=amount;
	if (cursor_x<0) cursor_x=0;
	shift_selection_update();
	set_flag_redraw_row();

}

void Pattern_Editor::cursor_move_right(int amount) {

	cursor_x+=amount;
	if (cursor_x>=song->get_abs_width()) cursor_x=song->get_abs_width()-1;
	
	if (get_cursor_column()==0)
		 midi_input.clear(); //switched track!
	
	shift_selection_update();
	set_flag_redraw_row();
}


void Pattern_Editor::cursor_move_field_right() {

	
	cursor_field++;
	if (cursor_field>=FIELDS_MAX) {

		if (cursor_x==song->get_abs_width()-1) cursor_field=FIELDS_MAX-1;
		else {
		
			cursor_move_right(1);
			cursor_field=0;
		}
	}

	shift_selection_update();
	set_flag_redraw_row();

}

void Pattern_Editor::cursor_move_field_left() {

	
	cursor_field--;
	if (cursor_field<0) {

		if (cursor_x==0) cursor_field=0;
		else {
		
			cursor_move_left(1);
			cursor_field=FIELDS_MAX-1;
		}
	}

	shift_selection_update();
	set_flag_redraw_row();
}

void Pattern_Editor::cursor_page_up() {

	cursor_step_up(song->get_pattern_hl_major(song->get_abs_pattern(cursor_y)));

}


void Pattern_Editor::cursor_page_down() {

	cursor_step_down(song->get_pattern_hl_major(song->get_abs_pattern(cursor_y)));
}


void Pattern_Editor::cursor_home() {

	if (cursor_field>0) {

		cursor_field=0;

	} else if (cursor_x>0) {

		cursor_x=0;
		cursor_field=0;
		
	} else {

		cursor_y=GetLowerLimit();
	}

	shift_selection_update();
}

void Pattern_Editor::cursor_end() {

	if (cursor_field<FIELDS_MAX-1) {

		cursor_field=FIELDS_MAX-1;

	} else if (cursor_x<song->get_abs_width()-1) {

		cursor_x=song->get_abs_width()-1;
		cursor_field=FIELDS_MAX-1;

	} else {

		cursor_y=GetUpperLimit();
	}

	shift_selection_update();
}


void Pattern_Editor::cursor_tab() {

	cursor_move_right(1);
	cursor_field=0;


}

void Pattern_Editor::cursor_back_tab() {

	shift_selection_end();

	if (cursor_field==0) cursor_move_left(1);
	else cursor_field=0;
}


void Pattern_Editor::cursor_next_pattern() {

	int increment;
	int real_row,real_pattern,real_pattern_length,last_pattern,next_pattern_length;

	last_pattern=song->get_patterns();
	real_pattern=song->get_abs_pattern(cursor_y);
	real_row=song->get_abs_row(cursor_y);
	real_pattern_length=song->get_pattern_length(real_pattern);

	if (real_pattern<last_pattern) {

		next_pattern_length=song->get_pattern_length(real_pattern+1);

		if (real_row<=(next_pattern_length-1)) {

			increment=real_pattern_length;

		} else {

			increment=next_pattern_length+((real_pattern_length-1)-real_row);
		}

		cursor_y+=increment;
		row_offset+=increment;

		if (locked_to_pattern) {

		
			selection_begin_y+=increment;
			selection_end_y+=increment;
			normalize_selection();
		}

	}





}

void Pattern_Editor::cursor_prev_pattern() {

	int decrement;
	int real_row,real_pattern,real_pattern_length,prev_pattern_length;

	real_pattern=song->get_abs_pattern(cursor_y);
	real_row=song->get_abs_row(cursor_y);
	real_pattern_length=song->get_pattern_length(real_pattern);

	if (real_pattern>0) {

		prev_pattern_length=song->get_pattern_length(real_pattern-1);


		if (real_row>=(prev_pattern_length)) {

			decrement=real_row+1;
		} else {

			decrement=prev_pattern_length;
		}

		cursor_y-=decrement;
		row_offset-=decrement;
		if (row_offset<0) row_offset=0;

		if (locked_to_pattern) {

		
			selection_begin_y-=decrement;
			selection_end_y-=decrement;
			normalize_selection();
		}


	}





}

void Pattern_Editor::cursor_insert() {

	int i,limit;
	limit=GetInsertLimit();

	for(i=limit;i>cursor_y;i--) song->abs_note_ref(cursor_x,i)=song->abs_note(cursor_x,i-1);
	song->abs_note_ref(cursor_x,cursor_y).clear();
}

void Pattern_Editor::cursor_delete() {

	int i,limit;
	limit=GetInsertLimit();

        for(i=cursor_y;i<limit;i++) song->abs_note_ref(cursor_x,i)=song->abs_note(cursor_x,i+1);

	song->abs_note_ref(cursor_x,limit).clear();

}







void Pattern_Editor::toggle_mask_at_cursor() {

	switch (cursor_field) {

		case 2:
		case 3:{ volume_mask=!volume_mask; } break;
		case 4:
		case 5:
		case 6:{ command_parameter_mask=!command_parameter_mask; } break;
		case 7:
		case 8:
		case 9:
		case 10:
		case 11: { controller_mask=!controller_mask; } break;
		
	}

}

void Pattern_Editor::clear_field_at_cursor() {

	switch (cursor_field) {

		case 0:
		case 1:{
			
			song->abs_note_ref(cursor_x,cursor_y).note=Note::CLEAR;
			song->abs_note_ref(cursor_x,cursor_y).volume=65;
		} break;

		case 2:
		case 3:{

			song->abs_note_ref(cursor_x,cursor_y).volume=65;
			last_volume=65;
		} break;
			
		case 4: {

			song->abs_note_ref(cursor_x,cursor_y).command=Note::CLEAR;
			last_command=song->abs_note_ref(cursor_x,cursor_y).command;
			last_parameter=song->abs_note_ref(cursor_x,cursor_y).parameter;
		} break;
		case 5:
		case 6:{

			song->abs_note_ref(cursor_x,cursor_y).parameter=0;
			last_command=song->abs_note_ref(cursor_x,cursor_y).command;
			last_parameter=song->abs_note_ref(cursor_x,cursor_y).parameter;
		} break;
		case 7:
		case 8:
		case 9: {
			song->abs_note_ref(cursor_x,cursor_y).controller_set=Note::CLEAR;
			last_controller_set=song->abs_note_ref(cursor_x,cursor_y).controller_set;
			last_controller_value=song->abs_note_ref(cursor_x,cursor_y).controller_value;
		} break;
		case 10:
		case 11: {

			song->abs_note_ref(cursor_x,cursor_y).controller_value=0;
			last_controller_set=song->abs_note_ref(cursor_x,cursor_y).controller_set;
			last_controller_value=song->abs_note_ref(cursor_x,cursor_y).controller_value;                    	
		} break;
		
	}

	cursor_move_down(cursor_spacing);

}


// keyboard internationalization
int Pattern_Editor::GiveNoteIncrement(char key) {

	//fixme: internationaliza it! :D

	int i;
	int tmpval=99;

	for (i=0;i<29;i++) if (noteincr[i]==key) tmpval=i;

	return tmpval;

}


void Pattern_Editor::default_octave_raise() {

	default_octave++;
	default_octave=BOUND(default_octave,0,9);

}

void Pattern_Editor::default_octave_lower() {

	default_octave--;
	default_octave=BOUND(default_octave,0,9);


}
char Pattern_Editor::get_default_octave() {

	return default_octave;
}



#define IS_LETTER(value) ((value>='A') && (value<='Z'))
#define IS_NUMBER(value) ((value>='0') && (value<='9'))
#define IS_HEX_NUMBER(value) ( ((value>='0') && (value<='9')) || ((value>='A') && (value<='F')) )
#define CHAR_TO_HEX(value) ((value>='0') && (value<='9'))?(value-'0'):((value>='A') && (value<='F'))?(10+(value-'A')):0
//a few macros!



//insert data stuff
bool Pattern_Editor::insert_note_at_cursor(char keynote) {

        Uint8 tmpnote;
	Uint8 tmpinc;
	bool success;
	success=false;

	tmpinc=GiveNoteIncrement(keynote);

	if (tmpinc!=99) {

		tmpnote=(12*default_octave+tmpinc); // 0 = nothing
		tmpnote=BOUND(tmpnote,0,127);
		
		song->abs_note_ref(cursor_x,cursor_y).note=tmpnote;

		//remember mask
		last_note=song->abs_note_ref(cursor_x,cursor_y).note;
		//and APPLY mask
		if (volume_mask) song->abs_note_ref(cursor_x,cursor_y).volume=last_volume;

		if (command_parameter_mask) {

			song->abs_note_ref(cursor_x,cursor_y).command=last_command;	
			song->abs_note_ref(cursor_x,cursor_y).parameter=last_parameter;		
		}

		if (controller_mask) {

			song->abs_note_ref(cursor_x,cursor_y).controller_set=last_controller_set;	
			song->abs_note_ref(cursor_x,cursor_y).controller_value=last_controller_value;	
		}

		//cursor moves
		cursor_move_down(cursor_spacing);
		success=true;
	}

	return success;

}

void Pattern_Editor::insert_octave_at_cursor(Uint8 octave) {
	
	song->abs_note_ref(cursor_x,cursor_y).note=(octave*12+(song->abs_note_ref(cursor_x,cursor_y).note) % 12); // 0 = nothing
	cursor_move_down(cursor_spacing);
}

void Pattern_Editor::insert_volume_at_cursor_field1(Uint8 volume) {

	char tmpvol;

	if (song->abs_note_ref(cursor_x,cursor_y).volume>64) song->abs_note_ref(cursor_x,cursor_y).volume=0;
	tmpvol=volume*10+(song->abs_note_ref(cursor_x,cursor_y).volume % 10);
	tmpvol=BOUND(tmpvol,0,64);
	song->abs_note_ref(cursor_x,cursor_y).volume=tmpvol;
	last_volume=tmpvol;

	cursor_move_field_right();
	
}

void Pattern_Editor::insert_volume_at_cursor_field2(Uint8 volume) {

        char tmpvol;
	if (song->abs_note_ref(cursor_x,cursor_y).volume>64) song->abs_note_ref(cursor_x,cursor_y).volume=0;
	tmpvol=song->abs_note_ref(cursor_x,cursor_y).volume/10*10+volume;
	tmpvol=BOUND(tmpvol,0,64);
        song->abs_note_ref(cursor_x,cursor_y).volume=tmpvol;
	last_volume=tmpvol;

	cursor_move_down(cursor_spacing);
	cursor_move_field_left();
	
}

void Pattern_Editor::insert_command_at_cursor(char command) {

	if (IS_LETTER(command)) { // A-Z command?

        	song->abs_note_ref(cursor_x,cursor_y).command=(command-'A');

	} else if (IS_NUMBER(command)) { // 0-9 command?
	
		song->abs_note_ref(cursor_x,cursor_y).command=25+(command-'0');
	}

	last_command=song->abs_note_ref(cursor_x,cursor_y).command;
	last_parameter=song->abs_note_ref(cursor_x,cursor_y).parameter;

	cursor_move_down(cursor_spacing);

}

void Pattern_Editor::insert_parameter_at_cursor_field1(Uint8 parameter) {

	song->abs_note_ref(cursor_x,cursor_y).parameter=parameter*0x10+song->abs_note_ref(cursor_x,cursor_y).parameter % 0x10;
	last_command=song->abs_note_ref(cursor_x,cursor_y).command;
	last_parameter=song->abs_note_ref(cursor_x,cursor_y).parameter;

	cursor_move_field_right();
}

void Pattern_Editor::insert_parameter_at_cursor_field2(Uint8 parameter) {

	song->abs_note_ref(cursor_x,cursor_y).parameter=parameter+song->abs_note_ref(cursor_x,cursor_y).parameter/0x10*0x10;
	last_command=song->abs_note_ref(cursor_x,cursor_y).command;
	last_parameter=song->abs_note_ref(cursor_x,cursor_y).parameter;

	cursor_move_down(cursor_spacing);
	cursor_move_field_left();
}

void Pattern_Editor::insert_controller_set_at_cursor(char controller_command,int field) {

	int multiplier;
	int tmpctrl;

	if (field==0) multiplier=100;
	if (field==1) multiplier=10;
	if (field==2) multiplier=1;	
	

	if (IS_LETTER(controller_command)) { // A-Z


                song->abs_note_ref(cursor_x,cursor_y).controller_set=128+(controller_command-'A');
		last_controller_set=song->abs_note_ref(cursor_x,cursor_y).controller_set;
                last_controller_value=song->abs_note_ref(cursor_x,cursor_y).controller_set;

		cursor_field=9; // to end of ccommand field
		cursor_move_down(cursor_spacing);	

	} else {  // wantsanumber!


		tmpctrl=song->abs_note_ref(cursor_x,cursor_y).controller_set;

	      	if ((tmpctrl==Note::CLEAR) || (tmpctrl>127)) tmpctrl=0; // if its 0.. ("...") well.. remains 0!

		tmpctrl-=((tmpctrl/multiplier) % 10)*multiplier;
		tmpctrl+=(controller_command-'0')*multiplier;

		if (tmpctrl>127) tmpctrl=127;

		song->abs_note_ref(cursor_x,cursor_y).controller_set=tmpctrl;

		last_controller_set=song->abs_note_ref(cursor_x,cursor_y).controller_set;
                last_controller_value=song->abs_note_ref(cursor_x,cursor_y).controller_set;

		if (field<2) cursor_move_field_right();
                else {
		 	cursor_move_down(cursor_spacing);
			cursor_field=7;	
		}

		
	}


}

void Pattern_Editor::insert_controller_value_at_cursor_field1(Uint8 value) {


	song->abs_note_ref(cursor_x,cursor_y).controller_value=value*0x10+song->abs_note_ref(cursor_x,cursor_y).controller_value % 0x10;
	last_controller_set=song->abs_note_ref(cursor_x,cursor_y).controller_set;
        last_controller_value=song->abs_note_ref(cursor_x,cursor_y).controller_set;

	cursor_move_field_right();
}

void Pattern_Editor::insert_controller_value_at_cursor_field2(Uint8 value) {

	song->abs_note_ref(cursor_x,cursor_y).controller_value=value+song->abs_note_ref(cursor_x,cursor_y).controller_value/0x10*0x10;
	last_controller_set=song->abs_note_ref(cursor_x,cursor_y).controller_set;
        last_controller_value=song->abs_note_ref(cursor_x,cursor_y).controller_set;

	cursor_move_down(cursor_spacing);
	cursor_move_field_left();
}



bool Pattern_Editor::press_key_at_cursor(int key) { // A-Z (caps) / 0-9
	
	bool success;
	success=false;

	switch (cursor_field) {

		case 0: { success=insert_note_at_cursor(key); } break;
		case 1: { if IS_NUMBER(key) insert_octave_at_cursor(key-'0'); } break;
		case 2: { if IS_NUMBER(key) insert_volume_at_cursor_field1(key-'0'); } break;
		case 3: { if IS_NUMBER(key) insert_volume_at_cursor_field2(key-'0'); } break;
		case 4: { if (IS_LETTER(key) || IS_NUMBER(key)) insert_command_at_cursor(key); } break;
		case 5: { if IS_HEX_NUMBER(key) insert_parameter_at_cursor_field1(CHAR_TO_HEX(key)); } break;
		case 6: { if IS_HEX_NUMBER(key) insert_parameter_at_cursor_field2(CHAR_TO_HEX(key)); } break;
		case 7:
		case 8:
		case 9: { if (IS_LETTER(key) || IS_NUMBER(key)) insert_controller_set_at_cursor(key,cursor_field-7); } break;
		case 10:{ if IS_HEX_NUMBER(key) insert_controller_value_at_cursor_field1(CHAR_TO_HEX(key)); } break;
		case 11:{ if IS_HEX_NUMBER(key) insert_controller_value_at_cursor_field2(CHAR_TO_HEX(key)); } break;
	}

	return success;
}




void Pattern_Editor::press_note_off_at_cursor() {

	song->abs_note_ref(cursor_x,cursor_y).note=Note::OFF;
	cursor_move_down(1);
}

void Pattern_Editor::perform_raise_at_cursor() {

	song->abs_note_ref(cursor_x,cursor_y).raise();

}

void Pattern_Editor::perform_lower_at_cursor() {

	song->abs_note_ref(cursor_x,cursor_y).lower();
}




