/***************************************************************************
                          event_execute_cache.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "event_execute.h"


void Event_Execute::verify_instrument_cache(int p_track) {


	if (check_device_changed(p_track)) {
	
		//FIXMETODO: stop all isntruments there
		track[p_track].cache.device_channel_in_use=false;
		track[p_track].cache.bank=-1;
		track[p_track].cache.device=song->get_instrument(p_track)->midi.device.get();
	}

	if (check_channel_changed(p_track)) {

		track[p_track].cache.channel=song->get_instrument(p_track)->midi.channel.get();
		track[p_track].cache.device_channel_in_use=false;
	}

	if (!track[p_track].cache.device_channel_in_use) {

		set_track_device_channel_in_use(p_track);

	} else {

	        if (check_instrument_settings_changed(p_track)) set_track_instrument(p_track);
	}


}



void Event_Execute::set_track_device_channel_in_use(int p_track) {

	int tmpdev;
	int tmpchan;
	int i;

	tmpdev=song->get_instrument(p_track)->midi.device.get();
	tmpchan=song->get_instrument(p_track)->midi.patch.get();

	for (i=0;i<song->get_tracks();i++) {

		if (i!=p_track) {
		
                	if ((track[i].cache.channel==track[p_track].cache.channel)
                          && (track[i].cache.device==track[p_track].cache.device)
			  && (track[i].cache.device_channel_in_use)
                        ) track[i].cache.device_channel_in_use=false;
		}
	}

	track[p_track].cache.device_channel_in_use=true;

	set_track_instrument(p_track);
}

// channel changed check

bool Event_Execute::check_channel_changed(int p_track) {

	return (!(track[p_track].cache.channel==song->get_instrument(p_track)->midi.channel.get()));

}

// device changed check

bool Event_Execute::check_device_changed(int p_track) {

	return (!(track[p_track].cache.device==song->get_instrument(p_track)->midi.device.get()));

}
// instrument changed check / set

bool Event_Execute::check_instrument_settings_changed(int p_track) {

	return (!
		(
		(track[p_track].cache.bank==song->get_instrument(p_track)->midi.bank.get())
		&& (track[p_track].cache.patch==song->get_instrument(p_track)->midi.patch.get())
		)
		);

}

void Event_Execute::set_track_instrument(int p_track) {

	track[p_track].cache.bank=song->get_instrument(p_track)->midi.bank.get();
   	track[p_track].cache.patch=song->get_instrument(p_track)->midi.patch.get();

	switch (get_current_bank(p_track)->bank_select_method) {

		case BANK_SELECT_METHOD_NONE: {

			midiout->send_MIDI_program(get_hw_device(p_track),get_hw_channel(p_track),song->get_instrument(p_track)->midi.patch.get());

		} break;

		case BANK_SELECT_MSB_LSB: {

			midiout->send_MIDI_control(get_hw_device(p_track),get_hw_channel(p_track),0,get_current_bank(p_track)->MSB);
			midiout->send_MIDI_control(get_hw_device(p_track),get_hw_channel(p_track),32,get_current_bank(p_track)->LSB);
			midiout->send_MIDI_program(get_hw_device(p_track),get_hw_channel(p_track),song->get_instrument(p_track)->midi.patch.get());

		} break;

		case BANK_SELECT_CUSTOM_STRING: {

			midiout->send_MIDI_program(get_hw_device(p_track),get_hw_channel(p_track),song->get_instrument(p_track)->midi.patch.get());

		} break;

	}
      	adjust_bender_sens(p_track);	
}

