/* $Id: console.c,v 1.6 2003/05/30 00:42:37 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef STANDALONE_TEST
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#else
static inline char *strchr(char *s, int c) {
	while (*s) {
		if (*s == c) {
			return s;
		}
		s++;
	}
	return 0;
}

static int console_handle;

unsigned long strlen(char *);

#endif

#include "cfe_api.h"

int open_console(cfe_xuint_t init_handle)
{
#ifndef STANDALONE_TEST
	/* Figure out what the console device is supposed to be... */
	console_handle = cfe_getstdhandle(CFE_STDHANDLE_CONSOLE);
	if (console_handle < 0) {
		return -1;
	}
#endif
	return 0;
}

void console_print(char *str)
{
#ifdef STANDALONE_TEST
	char foo = '\n';
#endif
	int count = 0;	
	char *p;
	
	/* Convert CR to CRLF as we write things out */
	
	while ((p = strchr(str,'\r'))) {
#ifdef STANDALONE_TEST
		write(1, str, p-str);
		write(1, &foo, 1);
#else  
		cfe_write(console_handle,(char *) str,p-str+1);
		cfe_write(console_handle,"\n",1);
#endif
		count += (p-str);
		str = p + 1;
	}
#ifdef STANDALONE_TEST
	write(1, str, strlen(str));
#else
	cfe_write(console_handle,(char *) str, strlen(str));
#endif
}

#ifdef CONFIG_BLOCKDEV
/* libext2fs wants this defined when you compile with -O0.  Must
   be inlined at -O2 or some such */
void com_err(const char *foo, long bar, const char *gla, ...) 
{
}
#endif


