/* $Id: getfile.c,v 1.5 2003/05/30 00:42:37 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "libc.h"
#include "getfile.h"

typedef struct file_handler_struct {
	file_ops_t *ops;
	struct file_handler_struct *next;
} file_handler_node_t;


static file_handler_node_t *handler_chain;

file_ops_t *file_handler_find(char *name, void **data)
{
	file_handler_node_t *tmp;
	void *priv;
	for (tmp = handler_chain; tmp; tmp = tmp->next) {
		priv = (*(tmp->ops->open))(name);
		if (priv) {
			(*data) = priv;
			return tmp->ops;
		}
	}
	return 0;
}

void file_handler_close(file_ops_t *ops,void *priv)
{
    ops->close(priv);
}

int file_handler_add(file_ops_t *ops)
{
	file_handler_node_t *new_node;
	new_node = lib_malloc(sizeof(file_handler_node_t));
	if (!new_node) {
		return -1;
	}
	new_node->ops = ops;
	new_node->next = handler_chain;
	handler_chain = new_node;
	return 0;
}

void file_handler_del(file_ops_t *ops)
{
	file_handler_node_t *tmp, *last = 0;
	for (tmp = handler_chain; tmp; tmp = tmp->next) {
		if (tmp->ops == ops) {
			if (last) {
				last->next = tmp->next;
 			} else {
				handler_chain = tmp->next;
			}
			lib_free(tmp);
			return;
		}
	}
	lib_die("File handler to delete not found\n");
}
