/* $Id: misc.h,v 1.5 2003/05/30 00:42:40 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _MISC_H
#define _MISC_H
#include "libc.h"
#include "port.h"

/*
 * Miscellaneous support functions that don't really 
 * belong anywhere else 
 */

/* 
 * dump (via lib_printf) a hex-dump style output of 
 * length bytes of the buffer pointed at by ptr 
 */
void dump_hex(void *ptr, int length);

/* 
 * Dump the low 6 bytes of addr in an ethernet-style address (e.g. 00:11:22:ff:33:gg)
 */
void dump_eth_addr(uint64_t addr);

/* 
 * Set packet fields at arbitrary alignments with the passed values.  
 * These functions also automatically convert to/from bigendian (network format)
 */
void set_uint16_field(uint8_t *field, uint16_t val);
void set_uint32_field(uint8_t *field, uint32_t val);
void set_uint48_field(uint8_t *field, uint64_t val);
uint16_t get_uint16_field(uint8_t *field);
uint32_t get_uint32_field(uint8_t *field);
uint64_t get_uint48_field(uint8_t *field);


#endif
