#
# bibliography package for Perl
#
# INSPEC style 4 routines
#
# Dana Jacobsen (dana@acm.org)
# 15 January 1996
#
# These routines convert style 4.  See the main INSPEC routines for more
# details on styles.

package bp_inspecWeb;

$version = "inspecWeb (ml 6 mar 2000)";

######

&bib'reg_format(
  'inspecWeb',   # name
  'ipW',       # short name
  'bp_inspecWeb',# package name
  '8859-1',    # default character set
  'suffix is inspec',
# functions
  'open      is standard',
  'close     is standard',
  'write     is standard',
  'clear',
  'read',
  'options',
  'explode',
  'tocanon',
  'implode   is unsupported',
  'fromcanon is unsupported',
);

######

$glb_last = '';
$opt_html = 0;

######

sub options {
  local($opt) = @_;

  &bib'panic("medline options called with no arguments!") unless defined $opt;
  &bib'debugs("parsing medline option '$opt'", 64);
  return undef unless $opt =~ /=/;
  local($_, $val) = split(/\s*=\s*/, $opt, 2);
  &bib'debugs("option split: $_ = $val", 8);
  /^html$/       && do { $opt_html = &bib'parse_num_option($val);
                         return 1; };
  undef;
}

######

sub clear {
  $glb_last = '';
}

######
my $opt_html = 1 ;

sub read {
  local($file) = @_;
  local($ent) = '';

  # XXXXXX This is bad -- we save up data from the last read in one
  #        variable.  We should at least index it by filename.

  return undef unless defined $glb_last;

  my $s ;
  if ($glb_last eq '') {
    # This is our first read on this file.  Throw away any headers.
    while (<$bib'glb_current_fh>) {
#      last if /^\s*INSPEC\s/;
       $s = $_ ;
       if ($opt_html ) {  1 while $s =~ s/<[^<>]*>// ;}
       last if ( $s=~ /^\s*Title:\s/ );
    }
    return undef if eof;
    $s =~ s/\r$//;
    $glb_last = $s;
  }
  while (<$bib'glb_current_fh>) {
    $s = $_ ;
    $s =~ s/\r$//;
#    last if /^\s*INSPEC\s/;
       if ($opt_html ) {  1 while $s =~ s/<[^<>]*>// ;}
      last if ($s =~ /^\s*Title:\s/) ;
    $ent .= $s;
  }
  substr($ent,0,0) = $glb_last;
  if (!eof) {
    $glb_last = $s;
  } else {
    $glb_last = undef;
  }
  $ent;
}

######


sub explode {
  local($rec) = @_;
  local(%entry);
  local(@lines);
  local($line);
  local($fld, $val);

  # Some extra magic is done here to deal with the way this INSPEC format
  # was poorly thought out.  It shoves extra fields into the data section
  # of various common fields, which makes it difficult to parse.

#  print "1rec: $rec|||\n";

#  print "1rec: $rec|||\n";
  $rec =~ s/\n ([A-Z])/\n$1/g;
#  print "2rec: $rec|||\n";
  1 while $rec =~ s/\n\s+([A-Z][\w .]+): ([^\n]+)  ([A-Z][\w .]+): ([^\n]+)/\n$1:   $2\n$3:   $4/;
#  print "3rec: $rec|||\n";
  1 while $rec =~ s/\n\s+([A-Z][\w .]+): ([^\n]+)\s*\n/\n$1:   $2\n/;
#  print "4rec: $rec|||\n";
  $rec =~ s/\s* p\.([\d- ,]+)\s*\n/\nPages:   $1\n/;
#  print "4arec: $rec|||\n";
  $rec =~ s/([;,]?)\s*no\.([\d-]+)\s*([,\n;]?)/$1\nNumber:   $2/;
#  print "4brec: $rec|||\n";
  $rec =~ s/([;,]?)\s*vol\.([\d-]+)\s*([,\n;]?)/$1\nVol:   $2/;
#  print "4crec: $rec|||\n";
  $rec =~ s/([;,]?)\s*pt\.([\d-]+)\s*([,\n;]?)/$1\nPart:   $2/;
#  print "5rec: $rec|||\n";
## XXXXXXX notice that this is not Y3K compliant!
  $rec =~ s/;\s*([\d-]*)\s*((Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[\w.]*)?\s+([12]\d{3}) *([;,]?)/;\nDate:   $1 $3 $4\n$5/;
  $rec =~ s/,\s*([\d-]*)\s*((Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)[\w.]*)?\s+([12]\d{3}) *([;,]?) *([^\n]*)\n/, $1 $3 $4 $5 $6\nDate2:   $1 $3 $4\n/;
#  print "6rec: $rec|||\n";
  $rec =~ s/\s*  ([ivx+\d]+) pp\.\s*\n/\nTotal Pages:   $1\n/;
#  print "7rec: $rec|||\n";
  $rec =~ s/(\n\s*Publisher:\s+[^\n]+)\n\s+([^\n]+)\n/$1\nPub Address:   $2\n/;
#  print "8rec: $rec|||\n";
  $rec =~ s/\s*\n\s+/ /g;
#  print "9rec: $rec|||\n";

#  # Parse the first line
  @lines = split(/\n/, $rec);
#  $line = shift @lines;
#  ($entry{'AN'}) = ($line =~ /^\s*INSPEC\s+(\S+)\s+/);
  foreach $line (@lines) {
    ($fld, $val) = ($line =~ /^\s*([^:]+):\s*(.*)$/);
    $val =~ s/[;,]\s*$// ;
    $entry{$fld} = $val;
  }
  $entry{'Title'} =~ s/[;.,]\s*$// ;  
  %entry;
}

######

######

sub tocanon {
  local(%ent) = @_;

  local(%can);
  local($field);
  local(@cname);
  local(@lines);

  $can{'CiteKey'} = $ent{'AN'};
  $can{'classification'} = $ent{'CC'};


  if (defined $ent{'Doc. Type'}) {
    local($_) = $ent{'Doc. Type'};
    $can{'CiteType'} = 'inproceedings'	if /^\s*Conference Paper\s*$/;
    $can{'CiteType'} = 'proceedings'	if /^\s*Conference Proceedings\s*$/;
    $can{'CiteType'} = 'article'	if /^\s*Journal Paper\s*$/;
    $can{'CiteType'} = 'article'	if /^\s*Article\s*$/;    
    $can{'CiteType'} = 'report'		if /^\s*Report\s*$/;
    $can{'CiteType'} = 'book'		if /^\s*Book\s*$/;
    $can{'CiteType'} = 'inbook'		if /^\s*Book Article\s*$/;
    $can{'CiteType'} = 'misc'		if /^\s*Patent\s*$/;
  }
  if (!defined $can{'CiteType'}) {
    if (defined $ent{'Doc. Type'}) {
      &bib'gotwarn("Unrecognized Doc Type: $ent{'Doc. Type'}");
    } else {
      &bib'gotwarn("No Doc. Type field");
    }
    $can{'CiteType'} = 'misc';
  }

  @cname = ();
  foreach $field (split(/\s*;\s*/, $ent{'Author'})) {
    push( @cname, &bp_util'name_to_canon($field, 'reverse') );
  }
  $can{'Authors'} = join($bib'cs_sep, @cname) if @cname;

  $can{'AuthorAddress'} = $ent{'Affiliation'} if defined $ent{'Affiliation'};

  @cname = ();
  foreach $field (split(/\s*;\s*/, $ent{'Editors'})) {
    push( @cname, &bp_util'name_to_canon($field, 'reverse') );
  }
  $can{'Editors'} = join($bib'cs_sep, @cname) if @cname;
  
  $can{'Title'}      = $ent{'Title'}       if defined $ent{'Title'};
  $can{'SuperTitle'} = $ent{'Conf. Title'} if defined $ent{'Conf. Title'};

  $can{'Journal'}    = $ent{'Journal'}     if defined $ent{'Journal'};
  $can{'Volume'}     = $ent{'Vol'}         if defined $ent{'Vol'};
  $can{'Number'}     = $ent{'Number'}         if defined $ent{'Number'};
  $can{'Number'}     = $ent{'Iss'}         if defined $ent{'Iss'};
  $can{'Part'}     = $ent{'Part'}         if defined $ent{'Part'};

  $can{'Pages'}      = $ent{'Pages'}       if defined $ent{'Pages'};
  $can{'Pages'}      = $ent{'Pages'}       if defined $ent{'Pages'};
  $can{'PagesWhole'} = $ent{'Total Pages'} if defined $ent{'Total Pages'};
  local ($month, $year) ;
  if( defined $ent{'Date'} ) {
    ($month, $year) = &bp_util'parsedate($ent{'Date'});
  } elsif( defined $ent{'Date2'} ) {
    ($month, $year) = &bp_util'parsedate($ent{'Date2'});
  }  
  $can{'Month'}      = $month              if (defined $month) && ($month ne '');
  $can{'Year'}       = $year               if (defined $year) && ($year ne '');
  $can{'ReportNumber'} = $ent{'Report No'} if defined $ent{'Report No'};
  $can{'Organization'} = $ent{'Issued by'} if defined $ent{'Issued by'};
  # Country of Publication
  $can{'Publisher'}  = $ent{'Publisher'}   if defined $ent{'Publisher'};
  $can{'PubAddress'} = $ent{'Pub Address'} if defined $ent{'Pub Address'};
  $can{'ISSN'}       = $ent{'ISSN'}        if defined $ent{'ISSN'};
  $can{'ISBN'}       = $ent{'ISBN'}        if defined $ent{'ISBN'};
  # CODEN
  $can{'CCC'}        = $ent{'CCC'}         if defined $ent{'CCC'};
  $can{'Language'}   = $ent{'Language'}    if defined $ent{'Language'};
  $can{'Subject'}    = $ent{'Treatment'}   if defined $ent{'Treatment'};
  $can{'Field'}    = $ent{'Subject'}   if defined $ent{'Subject'};  
  $can{'Abstract'}   = $ent{'Abstract'}    if defined $ent{'Abstract'};
  $can{'classification'} = $ent{'Classification'} if defined $ent{'Classification'};
  $can{'Keywords'}   = $ent{'Thesaurus'}   if defined $ent{'Thesaurus'};
  if (defined $ent{'Free Terms'}) {
    if (defined $can{'Keywords'}) {
      $can{'Keywords'} .= '; ' . $ent{'Free Terms'};
    } else {
      $can{'Keywords'} = $ent{'Free Terms'};
    }
  }
  # Conf. Date
  # Conf. Loc
  # Conf. Sponsor

  # CCETT outlining the main fields of activity
  # Numerical Index
  # Translation of


  $can{'OrigFormat'} = $version;

  %can;
}

#######################
# end of package
#######################

1;
