%{

/*
  A parser for slat permission mappings.
  Copyright (C) 2005 The MITRE Corporation

  Author: John D. Ramsdell

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "scanner.h"
#include "slat.h"

/* The semantics of a permission mapping are provided by the action
   function, which is defined elsewhere, and called by the perms
   non-terminal. */

%}

%union {
  int common;			/* Zero if a class was found */
  flow_dir_t flow;		/* Created by the dir non-terminal */
  char *id;
}

%token UNUSED
%token <common> CLASS COMMON
%token <id> IDENTIFIER
%type <flow> dir

%start flow
%%

flow:

| flow class_perms
;

class_perms:
  COMMON IDENTIFIER '{' perms '}'
| CLASS IDENTIFIER '{' perms '}'
| CLASS IDENTIFIER
;

perms:

| perms IDENTIFIER ':' dir
  {
    if (action($<common>-2, $<id>-1, $2, $4)) {
      yyerror("bad flow");
      YYERROR;
    }
  }
;

dir:
  IDENTIFIER
  {				/* Interpret an identifier as */
    if (!strcmp($1, "none"))	/* specifying a flow direction */
      $$ = FLOW_NONE;
    else if (!strcmp($1, "read"))
      $$ = FLOW_READ;
    else if (!strcmp($1, "write"))
      $$ = FLOW_WRITE;
    else {
      yyerror("bad flow direction");
      YYERROR;
    }
  }
| '{' IDENTIFIER IDENTIFIER '}'
  {
    if (!strcmp($2, "read") && !strcmp($3, "write"))
      $$ = FLOW_BOTH;
    else if (!strcmp($2, "write") && !strcmp($3, "read"))
      $$ = FLOW_BOTH;
    else {
      yyerror("bad flow direction");
      YYERROR;
    }
  }
| '{' IDENTIFIER '}'
  {
    if (!strcmp($2, "read"))
      $$ = FLOW_READ;
    else if (!strcmp($2, "write"))
      $$ = FLOW_WRITE;
    else {
      yyerror("bad flow direction");
      YYERROR;
    }
  }
| '{' '}'
  { $$ = FLOW_NONE; }
;
