static variable window = NULL;
static variable gc_blue, gc_green, gc_red_dots;
static variable radians_per_degree = 180/PI;

% Translate, Scale, and Rotate transforms {{{
% Transformation matrices expressed in homogeneous coordinates (i.e. with
% and extra dimension), so as to enable translation, scaling, and rotation
% all to be performed via matrix multiplication, and compose all 3 into a
% single transform operation
static variable RM = Double_Type[3,3];
static variable SM = Double_Type[3,3];
static variable TM = Double_Type[3,3];
RM[2,*] = [0,0,1];
SM[2,*] = [0,0,1];
TM[2,*] = [0,0,1];

static define translate(x, y)
{
   TM[0,*] =  [ 1, 0, x];
   TM[1,*] =  [ 0, 1, y];
   return TM;
}

static define scale(x, y)
{
   SM[0,*] = [ x, 0, 0];
   SM[1,*] = [ 0, y, 0];
   return SM;
}

static define rotate(angle)
{
   variable s = sin(angle), c = cos(angle);
   RM[0,*] = [ c, -s, 0];
   RM[1,*] = [ s, c, 0];
   return RM;
}

static define round_int(x) { return int(x + 0.5); }

static variable UnitCube = Double_Type[8,3], sqr2_2 = sqrt(2)/2;
UnitCube[0,*] = [0,0,1];
UnitCube[1,*] = [1,0,1];
UnitCube[2,*] = [1,1,1];
UnitCube[3,*] = [0,1,1];
UnitCube[4,*] = [sqr2_2, sqr2_2, 1];
UnitCube[5,*] = [1 + sqr2_2, sqr2_2, 1];
UnitCube[6,*] = [1 + sqr2_2, 1 + sqr2_2, 1];
UnitCube[7,*] = [sqr2_2, 1 + sqr2_2, 1];
% }}}

static define realize(layout, solid) % {{{
{ 
   solid.drawable = gtk_widget_get_window(layout);

   gc_blue = gdk_gc_new(gtk_widget_get_window(layout));
   gdk_gc_set_foreground(gc_blue, gdk_blue);

   gc_red_dots = gdk_gc_new(gtk_widget_get_window(layout));
   gdk_gc_set_foreground(gc_red_dots, gdk_red);
   gdk_gc_set_line_attributes(gc_red_dots, 1,
	 			GDK_LINE_ON_OFF_DASH,
				GDK_CAP_BUTT, GDK_JOIN_ROUND);
   gdk_gc_set_dashes(gc_red_dots, 0, [1,1], 2);

   gc_green = gdk_gc_new(gtk_widget_get_window(layout));
   gdk_gc_set_foreground(gc_green, gdk_green);
} % }}}

static define draw(solid) % {{{
{
   variable drawable = solid.drawable;
   variable span = 10*solid.zoom;
   variable transform = translate(solid.x, solid.y) 
		# scale(span*solid.aspect_x, span*solid.aspect_y)
		# rotate(-solid.angle);
   variable v0 = round_int(transform#UnitCube[0,*]);
   variable v1 = round_int(transform#UnitCube[1,*]);
   variable v2 = round_int(transform#UnitCube[2,*]);
   variable v3 = round_int(transform#UnitCube[3,*]);
   variable v4 = round_int(transform#UnitCube[4,*]);
   variable v5 = round_int(transform#UnitCube[5,*]);
   variable v6 = round_int(transform#UnitCube[6,*]);
   variable v7 = round_int(transform#UnitCube[7,*]);

   gdk_window_clear(drawable);

   gdk_draw_line(drawable, gc_blue, v0[0], v0[1], v1[0], v1[1]);
   gdk_draw_line(drawable, gc_red_dots, v1[0], v1[1], v2[0], v2[1]);
   gdk_draw_line(drawable, gc_red_dots, v2[0], v2[1], v3[0], v3[1]);
   gdk_draw_line(drawable, gc_blue, v3[0], v3[1], v0[0], v0[1]);

   gdk_draw_line(drawable, gc_blue, v4[0], v4[1], v5[0], v5[1]);
   gdk_draw_line(drawable, gc_blue, v5[0], v5[1], v6[0], v6[1]);
   gdk_draw_line(drawable, gc_blue, v6[0], v6[1], v7[0], v7[1]);
   gdk_draw_line(drawable, gc_blue, v7[0], v7[1], v4[0], v4[1]);

   gdk_draw_line(drawable, gc_blue, v0[0], v0[1], v4[0], v4[1]);
   gdk_draw_line(drawable, gc_blue, v1[0], v1[1], v5[0], v5[1]);
   gdk_draw_line(drawable, gc_red_dots, v2[0], v2[1], v6[0], v6[1]);
   gdk_draw_line(drawable, gc_blue, v3[0], v3[1], v7[0], v7[1]);
} % }}}

static define expose(layout, evt, solid) % {{{
{
   draw(solid);
   return TRUE;
} % }}}

static define motion(layout, event, solid) % {{{
{
   variable x, y;
   gtk_widget_get_pointer(layout, &x, &y);
   solid.x = x ; solid.y = y;
   draw(solid);
   return TRUE;
} % }}}

static define zoom(zoomer, solid) % {{{
{
   solid.zoom = gtk_range_get_value(zoomer);
   draw(solid);
} % }}}

static define aspect(spinb, solid, axis) % {{{
{
   if (axis == 0)
      solid.aspect_x = gtk_spin_button_get_value_as_int(spinb);
   else
      solid.aspect_y = gtk_spin_button_get_value_as_int(spinb);

   draw(solid);
} % }}}

static define spin(rotator, solid) % {{{
{
   solid.angle = gtk_range_get_value(rotator) / radians_per_degree;
   draw(solid);
} % }}}

define create_cube(test) % {{{
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	() = g_signal_connect (window, "destroy",
				&gtk_widget_destroyed,
				&window);

	gtk_window_set_title(window, "Wireframe Cube");
	gtk_window_set_default_size(window, 550, 550);

	variable vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(window,vbox);

	variable solid = struct {x,y,zoom,angle,drawable,aspect_x,aspect_y};
	solid.x = 100; solid.y = 100; solid.zoom = 4; solid.angle=0;
	solid.aspect_x = 1; solid.aspect_y = 1;

	variable frame = gtk_frame_new("Drawing Area");
	gtk_box_pack_start(vbox, frame, TRUE, TRUE, 5);
	variable layout = gtk_layout_new(NULL,NULL);
	gtk_container_add(frame,layout);
	() = g_signal_connect(layout, "realize", &realize, solid);
	() = g_signal_connect(layout, "expose-event", &expose, solid);
	() = g_signal_connect(layout, "button-press-event", &motion, solid);

	frame = gtk_frame_new("Control  (click mouse above to move solid)");
	gtk_box_pack_start(vbox, frame, FALSE, FALSE, 5);

	variable cvbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(frame, cvbox);

	variable hbox = gtk_hbox_new(TRUE, 5);
	gtk_box_pack_end(cvbox, hbox, FALSE, FALSE, 5);
	variable button = gtk_button_new_with_label("Done");
	() = g_signal_connect_swapped(button, "clicked", &gtk_widget_destroy,
				      					window);
	gtk_box_pack_start(hbox,button,FALSE,FALSE,20);
	test.lower = button;

	variable scale_box = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(cvbox, scale_box, FALSE, FALSE, 5);
	variable label = gtk_label_new("Magnification");
	gtk_box_pack_start(scale_box, label, FALSE, FALSE, 5);

	variable zoomer = gtk_hscale_new_with_range(1,32,1);
	gtk_box_pack_start(scale_box, zoomer, TRUE, TRUE, 10);
	gtk_range_set_value(zoomer, solid.zoom);
	() = g_signal_connect(zoomer,"value_changed", &zoom, solid);

	label = gtk_label_new("Angle");
	gtk_box_pack_start(scale_box, label, FALSE, FALSE, 5);

	variable rotator = gtk_hscale_new_with_range(0, 360, 10);
	gtk_box_pack_start(scale_box, rotator, TRUE, TRUE, 10);
	() = g_signal_connect(rotator,"value_changed", &spin, solid);

	scale_box = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(cvbox, scale_box, FALSE, FALSE, 5);
	label = gtk_label_new("Aspect Ratio: ");
	gtk_box_pack_start(scale_box, label, FALSE, FALSE, 5);

	label = gtk_label_new("X");
	gtk_box_pack_start(scale_box, label, FALSE, FALSE, 5);
	variable ar = gtk_spin_button_new_with_range(1, 10, 1);
	gtk_box_pack_start(scale_box, ar, FALSE, FALSE, 5);
	() = g_signal_connect (ar, "value_changed", &aspect, solid, 0);

	label = gtk_label_new("Y");
	gtk_box_pack_start(scale_box, label, FALSE, FALSE, 5);
	ar = gtk_spin_button_new_with_range(1, 10, 1);
	gtk_box_pack_start(scale_box, ar, FALSE, FALSE, 5);
	() = g_signal_connect (ar, "value_changed", &aspect, solid, 1);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
} % }}}
