static variable window = NULL;

define create_menu ();
define create_menu (depth, length, tearoff)
{
   if (depth < 1)
	return NULL;

   variable menuitem;
   variable menu = gtk_menu_new ();
   variable group = NULL;

   if (tearoff) {
	menuitem = gtk_tearoff_menu_item_new ();
	gtk_menu_shell_append (menu, menuitem);
   }

   variable image = gtk_image_new_from_stock(GTK_STOCK_OPEN,GTK_ICON_SIZE_MENU);
   menuitem = gtk_image_menu_item_new_with_label ("Image item");
   gtk_image_menu_item_set_image (menuitem, image);
   gtk_menu_shell_append (menu, menuitem);
 
   variable i, j, buf;

   for (i = 0, j = 1; i < length; i++, j++) {

	buf = sprintf ("item %2d - %d", depth, j);
	menuitem = gtk_radio_menu_item_new_with_label (group, buf);
	group = gtk_radio_menu_item_get_group (menuitem);

	if (depth mod 2)
	   gtk_check_menu_item_set_show_toggle ( menuitem, TRUE);

	gtk_menu_shell_append (menu, menuitem);
	if (i == 3)
	   gtk_widget_set_sensitive (menuitem, FALSE);

	if (i == 5)
	   gtk_check_menu_item_set_inconsistent ( menuitem, TRUE);

	if (i < 5)
	   gtk_menu_item_set_submenu (menuitem, 
	      		create_menu (depth - 1, 5,  TRUE));
   }

   return menu;
}

define create_menus (test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	() = g_signal_connect (window,"destroy",&gtk_widget_destroyed,&window);
	() = g_signal_connect (window,"delete-event", &gtk_true, NULL);
      
	variable accel_group = gtk_accel_group_new ();
	gtk_window_add_accel_group (window, accel_group);

	gtk_window_set_title (window, "menus");
	gtk_container_set_border_width ( window, 0);
      
      
	variable box1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add ( window, box1);
      
	variable menubar = gtk_menu_bar_new ();
	gtk_box_pack_start (box1, menubar, FALSE, TRUE, 0);
      
	variable menu = create_menu (2, 50, TRUE);
	variable menuitem = gtk_menu_item_new_with_label ("test\nline2");
	gtk_menu_item_set_submenu (menuitem, menu);
	gtk_menu_shell_append (menubar, menuitem);
      
	menuitem = gtk_menu_item_new_with_label ("foo");
	gtk_menu_item_set_submenu (menuitem, create_menu (3, 5, TRUE));
	gtk_menu_shell_append (menubar, menuitem);

	variable image = gtk_image_new_from_stock (GTK_STOCK_HELP,
                                        GTK_ICON_SIZE_MENU);
	menuitem = gtk_image_menu_item_new_with_label ("Help");
	gtk_image_menu_item_set_image (menuitem, image);
	gtk_menu_item_set_submenu (menuitem, create_menu (4, 5, TRUE));
	gtk_menu_item_set_right_justified (menuitem, TRUE);
	gtk_menu_shell_append (menubar, menuitem);

	menubar = gtk_menu_bar_new ();
	gtk_box_pack_start (box1, menubar, FALSE, TRUE, 0);
      
	menu = create_menu (2, 10, TRUE);
      
	menuitem = gtk_menu_item_new_with_label ("Second menu bar");
	gtk_menu_item_set_submenu (menuitem, menu);
	gtk_menu_shell_append (menubar, menuitem);
      
	variable box2 = gtk_vbox_new (FALSE, 10);
	gtk_container_set_border_width ( box2, 10);
	gtk_box_pack_start (box1, box2, TRUE, TRUE, 0);
      
	menu = create_menu (1, 5, FALSE);
	gtk_menu_set_accel_group ( menu, accel_group);

	menuitem = gtk_image_menu_item_new_from_stock (
	      					GTK_STOCK_NEW,accel_group);
	gtk_menu_shell_append (menu, menuitem);
      
	menuitem = gtk_check_menu_item_new_with_label ("Accelerate Me");
	gtk_menu_shell_append (menu, menuitem);
	gtk_widget_add_accelerator (menuitem,
				  "activate",
				  accel_group,
				  GDK_F1,
				  0,
				  GTK_ACCEL_VISIBLE);
	menuitem = gtk_check_menu_item_new_with_label ("Accelerator Locked");
	gtk_menu_shell_append (menu, menuitem);
	gtk_widget_add_accelerator (menuitem,
				  "activate",
				  accel_group,
				  GDK_F2,
				  0,
				  GTK_ACCEL_VISIBLE | GTK_ACCEL_LOCKED);
	menuitem = gtk_check_menu_item_new_with_label ("Accelerators Frozen");
	gtk_menu_shell_append (menu, menuitem);
	gtk_widget_add_accelerator (menuitem,
				  "activate",
				  accel_group,
				  GDK_F2,
				  0,
				  GTK_ACCEL_VISIBLE);
	gtk_widget_add_accelerator (menuitem,
				  "activate",
				  accel_group,
				  GDK_F3,
				  0,
				  GTK_ACCEL_VISIBLE);
      
	variable omenu = gtk_option_menu_new ();
	gtk_option_menu_set_menu ( omenu, menu);
	gtk_option_menu_set_history ( omenu, 3);
	gtk_box_pack_start (box2, omenu, TRUE, TRUE, 0);

	menu = gtk_menu_new();
	foreach( ["short", "longer", "StillLonger", "AndMuchLongerStill"]) {
	   variable l = ();
	   variable widget = gtk_menu_item_new_with_label( l );
	   % Render each item, so menu can "know" size of its largest
	   % element and be created wide enough to accommodate it.
	   % Without this the menu may be resized when elements
	   % larger than its default element are later selected.
	   gtk_widget_show(widget);
	   gtk_menu_shell_append( menu, widget );
	}

	omenu = gtk_option_menu_new();
	gtk_option_menu_set_menu( omenu, menu );
	gtk_box_pack_start( box2, omenu, FALSE, FALSE, 5 );

	test.lower = generic_close_button(box1,window);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
