/* -*- mode: C; mode: fold; -*- */

/* SLgtk:  S-Lang bindings for GTK+ widget set
 *
 * Copyright (C) 2003-2004 Massachusetts Institute of Technology 
 * Copyright (C) 2002 Michael S. Noble <mnoble@space.mit.edu>
 *
 * This software was partially developed by the MIT Center for Space
 * Research under contract SV1-61010 from the Smithsonian Institution.
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * the supporting documentation, and that the name of the Massachusetts
 * Institute of Technology not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  The Massachusetts Institute of Technology makes
 * no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 * 
 * THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE MASSACHUSETTS
 * INSTITUTE OF TECHNOLOGY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <slang.h>
#include "config.h"
#include "glib-object.h"
#include "slirpcompat.h"

#define SIZEOF_POINTER		SIZEOF_CHAR_P
#define MODULE_NAME		"SLgtk"

extern int	slgtk_debug;

extern void	error_terminate_main_loop	(char* msg);

extern GClosure*  slg_closure_new	(SLang_Name_Type *function,
					SLang_Any_Type **args,
					unsigned int nargs,
					SLang_Any_Type *swap_data);

extern GValue   _GValue_Initializer;

extern int	pop_g_value		(GValue *val);

extern int	push_g_value		(const GValue *val);

extern int 	push_boxed		(const GValue *val);


extern int	usage_err		(int expected_nargs,
      					const char *usage_str);

extern void	free_malloced_string_array	(char **strs, unsigned int n);

extern int	pop_key_val_pairs 	(unsigned int n,
      						char ***keysp, char ***valsp);

extern int	extract_slang_args	(unsigned int nargs,
      					SLang_Any_Type ***pargs);

extern void	free_slang_args		(unsigned int nargs,
      					SLang_Any_Type **pargs);

extern void	patch_ftable		(SLang_Intrin_Fun_Type *func_array,
					SLtype dummy_id,
					SLtype actual_id);

extern SLang_CStruct_Field_Type 	GdkColor_Layout[];
extern SLang_CStruct_Field_Type 	GdkRectangle_Layout[];
extern SLang_CStruct_Field_Type 	GdkCursor_Layout[];
extern SLang_CStruct_Field_Type 	GdkPoint_Layout[];
extern SLang_CStruct_Field_Type 	*GtkAllocation_Layout;
extern SLang_CStruct_Field_Type		GError_Layout[];
extern SLang_CStruct_Field_Type		GParamSpec_Layout[];

#define O 		255

#define I               SLANG_INT_TYPE
#define UI              SLANG_UINT_TYPE
#define UL              SLANG_ULONG_TYPE
#define UC              SLANG_UCHAR_TYPE
#define S               SLANG_STRING_TYPE
#define F               SLANG_FLOAT_TYPE
#define D               SLANG_DOUBLE_TYPE
#define R               SLANG_REF_TYPE

#define BEGIN_DECLS
#define END_DECLS
