#
# Copyright (c) 2004 Conectiva, Inc.
#
# Written by Gustavo Niemeyer <niemeyer@conectiva.com>
#
# This file is part of Smart Package Manager.
#
# Smart Package Manager is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as published
# by the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
#
# Smart Package Manager is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Smart Package Manager; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
from smart.interfaces.qt.progress import QtProgress
from smart.interfaces.qt.changes import QtChanges
from smart.interface import Interface, getScreenWidth
from smart.util.strtools import sizeToStr, printColumns
from smart.const import OPTIONAL, ALWAYS
from smart.fetcher import Fetcher
from smart.report import Report
from smart import *
import getpass
import sys
import os


try:
	from qt import *
	#from PyQt4.QtCore import QApplication
	
except:
	print _("You need PyQt installed in your system,"
		" please install with your package manager.")
	exit(-1)

app = QApplication(sys.argv)

class QtInterface(Interface):

    def __init__(self, ctrl, argv):
        Interface.__init__(self, ctrl)
	
        self._progress = QtProgress(False)
        self._hassubprogress = QtProgress(True)

	self.changesWindow = QtChanges()
	self._window = None
	self._sys_excepthook = sys.excepthook

    def run(self, command=None, argv=None):
        self.setCatchExceptions(True)
        result = Interface.run(self, command, argv)
        self.setCatchExceptions(False)
        return result

    def getProgress(self, obj, hassub=False):
        if hassub:
            self._progress.hide()
            fetcher = isinstance(obj, Fetcher) and obj or None
            self._hassubprogress.setFetcher(fetcher)
            return self._hassubprogress
        else:
            self._hassubprogress.hide()
            return self._progress


    def getSubProgress(self, obj):
        return self._hassubprogress

    def message(self, level, msg):
	print "NEW MESSAGE TO IMPLEMENT IN QT---> level= "+level+"  msg= "+msg


    def askYesNo(self, question, default=False):
        response = QMessageBox.question(self._window,
                                	_("Question..."),
					question,
					QMessageBox.Yes,
					QMessageBox.No)


        if response == QMessageBox.Yes:
            return True
        elif response == QMessageBox.No:
            return False
        else:
            return default

    def askContCancel(self, question, default=False):
	response = QMessageBox.question(self._window,
                                   _("Question..."),
				   question,
				   _("Continue"),
				   _("Cancel"),
				   )

	#response.setButtonText(QMessageBox.Ok, )
	
        if response == 0:
            return True
        elif response == 1:
            return False
        else:
            return default

    def askOkCancel(self, question, default=False):
 	response = QMessageBox.question(self._window,
                                   _("Question..."),
				   question,
				   QMessageBox.Ok,
				   QMessageBox.Cancel)

	
        if response == QMessageBox.Ok:
            return True
        elif response == QMessageBox.Cancel:
            return False
        else:
            return default

    def confirmChangeSet(self, changeset):
        return self.changesWindow.showChangeSet(changeset, confirm=True)

    def confirmChange(self, oldchangeset, newchangeset, expected=1):
        changeset = newchangeset.difference(oldchangeset)
        keep = []
        for pkg in oldchangeset:
            if pkg not in newchangeset:
                keep.append(pkg)
        if len(keep)+len(changeset) <= expected:
            return True
        return self.changesWindow.showChangeSet(changeset, keep=keep, confirm=True)

    def askInput(self, prompt, message=None, widthchars=None, echo=True):
	if (message != None):
		stringToShow = message + "\n" + prompt
	else:
		stringToShow = prompt
		
	text, ok = QInputDialog.getText( _("Input"), stringToShow)
    		
	if (ok and text != None):
		return text
	else:
		return ""
	
    def message(self, type, msg):
	
	message = QMessageBox.information(None, "Message",  msg)
	

    def insertRemovableChannels(self, channels):
	question = _("Insert one or more of the following removable "
                     "channels:\n")
        question += "\n"
        for channel in channels:
            question += "    "
            question += channel.getName()
            question += "\n"
        return self.askOkCancel(question, default=True)

    # Non-standard interface methods:


    def _excepthook(self, type, value, tb):
        if issubclass(type, Error) and not sysconf.get("log-level") is DEBUG:
            self._hassubprogress.hide()
            self._progress.hide()
            iface.error(str(value[0]))
        else:
            import traceback
            lines = traceback.format_exception(type, value, tb)
            iface.error("\n".join(lines))

    def setCatchExceptions(self, flag):
        if flag:
            sys.excepthook = self._excepthook
        else:
            sys.excepthook = self._sys_excepthook

    def hideProgress(self):
        self._progress.hide()
        self._hassubprogress.hide()
	


# vim:ts=4:sw=4:et
