#include <string.h>
#include <stdlib.h>
#include "list.h"
#include "common.h"
#include "buffer.h"
#include "array.h"

#define NumberPerSlice	128
#define a_elem(buf,i)	(((void**)(&(buf)->data))[(i)])

BUFFERMANAGER	ArrayData = {"Array", 1024, 0, NumberPerSlice * sizeof(void*),
			STATIC_LIST_INITIALIZER(ArrayData.list),
			PTHREAD_MUTEX_INITIALIZER};

void init_array(ARRAY *array){
    array->count = 0;
    init_list(&array->list);
}

void destroy_array(ARRAY *array){
    BUFFER      *buf;    

    while(!is_list_empty(&array->list)){
	buf = first_elem(&array->list);
	remove_from_list(&array->list, buf);
	ReleaseBuffer(buf);
    }
}

void* array_elem(ARRAY *array, int i){
    BUFFER	*buf;

    if ((array->count <= i) || (i < 0)) return NULL;
    
    buf = first_elem(&array->list);
    while(is_valid_elem(&array->list, buf)){
	if (i < NumberPerSlice) return a_elem(buf, i);
	buf = next_elem(buf);
	i -= NumberPerSlice;
    }
    DPRINT(0, "Warning!!! Array is damaged\n");
    return NULL;
}

int array_count(ARRAY *array){
    return array->count;
}

int add_to_array_back(ARRAY *array, void *elem){
    BUFFER	*buf;
    int		i;

    if (array->count % NumberPerSlice == 0){
	if ((buf = GetBuffer(&ArrayData)) == NULL) return 0;
	add_to_list_back(&array->list, buf);
    }
    i = array->count;
    buf = first_elem(&array->list);
    while(is_valid_elem(&array->list, buf)){
	if (i < NumberPerSlice){
	    a_elem(buf, i) = elem;
	    array->count++;
	    return 1;
	}
	buf = next_elem(buf);
	i -= NumberPerSlice;
    }
    DPRINT(0, "Warning!!! Array is damaged\n");
    return 0;
}

int remove_from_array(ARRAY *array, int i){
    BUFFER	*buf;

    if ((array->count <= i) || (i < 0)) return 0;

    buf = first_elem(&array->list);
    while(is_valid_elem(&array->list, buf)){
	if (i < NumberPerSlice) break;
	buf = next_elem(buf);
	i -= NumberPerSlice;
    }
    
    if (!is_valid_elem(&array->list, buf)){
	DPRINT(0, "Warning!!! Array is damaged\n");                                    
	return 0;	
    }
    
    array->count--;
    while(is_valid_elem(&array->list, buf)){
	memmove(&a_elem(buf, i), &a_elem(buf, i + 1), 
	    (NumberPerSlice - i - 1) * sizeof(void*));
	if (is_valid_elem(&array->list, next_elem(buf)))
	    a_elem(buf, NumberPerSlice - 1) = 
		a_elem((BUFFER*)next_elem(buf), 0);
	buf = next_elem(buf);
	i = 0;
    }

    if (array->count % NumberPerSlice == 0){
	buf = last_elem(&array->list);
	remove_from_list(&array->list, buf);
	ReleaseBuffer(buf);
    }
    return 1;
}
