/*
 * dvencoder.h -- DV Encoder Classes
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_DV_ENCODER_PARAMS_
#define _KINO_DV_ENCODER_PARAMS_

#include "DVScalingParams.h"
#include "DVEncoderImageParams.h"
#include "DVEncoderAudioParams.h"

/** Helper class for all image and audio encoding parameters.
*/

class DVEncoderParams : 
	virtual public DVEncoderImageParams, 
	virtual public DVScalingParams, 
	virtual public DVEncoderAudioParams
{
	public:
		void SetParams( DVEncoderParams &params )
		{
			SetPAL( params.GetPAL( ) );
			SetEncodePasses( params.GetEncodePasses( ) );
			SetStaticQno( params.GetStaticQno( ) );
			SetWide( params.GetWide( ) );
			SetScale( params.GetScale( ) );
			SetAudioFile( params.GetAudioFile( ) );
			SetAudioLoop( params.GetAudioLoop( ) );
			SetFrequency( params.GetFrequency( ) );
			SetChannels( params.GetChannels( ) );
			SetBitsPerSample( params.GetBitsPerSample( ) );
			DV_RGB rgb;
			params.GetBackgroundColour( rgb );
			SetBackgroundColour( rgb );
			SetTwoPassEncoding( params.GetTwoPassEncoding( ) );
		}
};

#endif
