/*
 * RawDVFileInput.cc -- DV Pump and Sundry Common Implementations
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include "RawDVFileInput.h"
#include <frame.h>
#include <stdio.h>

/** RawDVFileInput implementation - Reads raw dv input from the FILE stream 
	provided.
*/

void RawDVFileInput::SetFile( FILE *_file )
{
	file = _file;
}

/** Returns the FILE associated to the input stream.
*/

FILE *RawDVFileInput::GetFile( )
{
	return file;
}

/** Reads the raw DV frame from the FILE.
*/

bool RawDVFileInput::ReadFrame( Frame &frame )
{
	bool ret = false;
	
	ret = fread( frame.data, 120000, 1, file ) == 1;
	if ( ret && frame.data[ 3 ] & 0x80 )
		ret = fread( frame.data + 120000, 24000, 1, GetFile( ) ) == 1;

	frame.playlist_position = index ++;
		
	return ret;
}


