/*
 * ----------------------------------------------------
 *
 * Standard  ARM Vector Floating Point unit 
 * ARM document: VFP9-S Vector Floating point coprocessor r0p2 
 * (C) 2005 Jochen Karrer 
 *   Author: Jochen Karrer
 *
 *  State: Nothing implemented
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include "coprocessor.h" 
#include "arm9cpu.h"

#define FPSCR_IOC		(1<<0)
#define FPSCR_DZC		(1<<1)
#define FPSCR_OFC		(1<<2)
#define FPSCR_UFC		(1<<3)
#define FPSCR_IXC		(1<<4)
#define FPSCR_IDC		(1<<7)
#define FPSCR_IOE		(1<<8)
#define FPSCR_DZE		(1<<9)
#define FPSCR_OFE		(1<<10)
#define FPSCR_UFE		(1<<11)
#define FPSCR_IXE		(1<<12)
#define FPSCR_IDE		(1<<15)
#define FPSCR_LEN_SHIFT		(16)
#define FPSCR_LEN_MASK		(7<<16)
#define FPSCR_STRIDE_SHIFT 	(20)
#define FPSCR_STRIDE_MASK 	(3<<20)
#define FPSCR_RMODE_SHIFT	(22)
#define FPSCR_RMODE_MASK	(3<<22)
#define FPSCR_FZ		(1<<24)
#define FPSCR_DN		(1<<25)
#define FPSCR_V			(1<<28)
#define FPSCR_C			(1<<29)
#define FPSCR_Z			(1<<30)
#define FPSCR_N			(1<<31)


typedef struct ArmVfp {
	uint32_t fpsid;
	uint32_t fpcsr;
	uint32_t fpexc;
	uint32_t fpinst;
	uint32_t fpinst2;
	union {
		uint32_t s[32];
		uint64_t d[16];
	} regs;
	ArmCoprocessor copro10;
	ArmCoprocessor copro11;
} ArmVfp;

/*
 * ------------------------------------
 * The instance of the ArmVfp 
 * ------------------------------------
 */
static ArmVfp arm_vfp = {
	.copro10 = {
		.mrc = NULL,
		.mcr = NULL,
		.cdp = NULL,
		.ldc = NULL,
		.stc = NULL,
	},
	.copro11 = {
		.mrc = NULL,
		.mcr = NULL,
		.cdp = NULL,
		.ldc = NULL,
		.stc = NULL
	}
	
};

void 
ArmVfp_Init(char *vfpname)  {
	ArmVfp *vfp = &arm_vfp;
	ARM9_RegisterCoprocessor(&vfp->copro10,10);
	ARM9_RegisterCoprocessor(&vfp->copro11,11);
	vfp->fpsid = 0x410101A0; /* VFP 9 */
	
	fprintf(stderr,"Registered Vector Floating Point coprocessor 10 and 11\n");
};

