/*
 * ------------------------------------------------------------------------------
 * 
 * (C) 2006 Jochen Karrer
 *
 *  State: nothing works
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * -----------------------------------------------------------------------------
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>

#include <idecode.h>
#include <signode.h>
#include <mmu.h>
#include <ste10_100.h>
#include <fio.h>
#include <bus.h>
#include <amdflash.h>
#include <configfile.h>
#include <phy.h>
#include <debugserver.h>
#include <loader.h>
#include <i2c_serdes.h>
#include "boards.h"


static int
board_nxdb500_create()
{
        ArmCoprocessor *copro;
 //       BusDevice *dev;

        Bus_Init(MMU_InvalidateTlb,4*1024);
        ARM9_New();
        copro = MMU_Create("mmu",TARGET_BYTEORDER,MMU_ARM926EJS | MMUV_NS9750);
        ARM9_RegisterCoprocessor(copro,15);


        //create_i2c_devices();
        //create_signal_links();
        return 0;
}


static void
board_nxdb500_run(Board *bd) {
        ARM9_Run();
}

#define DEFAULTCONFIG \
"[global]\n" \
"start_address: 0\n"\
"[dram0]\n" \
"size: 32M\n" \
"\n" \
"[loader]\n" \
"load_address: 0x50000000\n"\
"\n" \
"[dram1]\n"\
"size: 32M\n"\
"\n"\
"[flash1]\n"\
"type: AM29LV256ML\n"\
"chips: 1\n"\
"\n"
 
Board board_lacc = {
        .name = "NXDB500",
        .description =  "NXDB500 ARM Controller Card",
        .createBoard =  board_nxdb500_create,
        .runBoard =     board_nxdb500_run,
        .defaultconfig = DEFAULTCONFIG
};
