/* specter_LOCAL.c
 *
 * specter input plugin for: - local time of packet
 *                           - hostname of localhost
 *
 * (C) 2001-2002 by Florent AIDE <faide@alphacent.com>
 * with the help of Moez MKADMI <moez.mka@voila.fr>
 * shamelessly ripped from Harald Welte
 *
 * 2002 extended by Martin Kaehmer <teg@mompl.org>
 *
 * 11 Jun 2004, Michal Kwiatkowski <ruby@joker.linuxstuff.pl>:
 *     Fixed for specter.
 *
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 
 *  as published by the Free Software Foundation
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/time.h>
#include <specter/specter.h>

#ifndef HOST_NAME_MAX
#warning this libc does not define HOST_NAME_MAX
#define HOST_NAME_MAX   (256)
#endif


#define LOCAL_RETS_NUM 2
static specter_iret_t local_rets[LOCAL_RETS_NUM] = {
	{ .type = SPECTER_IRET_UINT32, .name = "local.time" },
	{ .type = SPECTER_IRET_STRING, .name = "local.hostname" },
};

static char hostname[HOST_NAME_MAX+1];


static int _interp_local(ulog_packet_msg_t *trash)
{
	struct timeval tv;

	/* Get date */
	gettimeofday(&tv, NULL);

	/* put date */
	local_rets[0].value.ui32 = (unsigned long) tv.tv_sec;
	local_rets[0].flags |= SPECTER_RETF_VALID;
	local_rets[1].value.ptr = hostname;
	local_rets[1].flags |= SPECTER_RETF_VALID;

	return 0;
}

static specter_input_t local = {
	.name = "local",
	.input = &_interp_local
};

void _init(void)
{
	/* get hostname */
	char *tmp;
	if (gethostname(hostname, sizeof(hostname)) < 0) {
		specter_log(SPECTER_FATAL, "Couldn't gethostname(): %s.\n",
			strerror(errno));
		exit(EXIT_FAILURE);
	}
	/* strip off everything after first '.' */
	if ((tmp = strchr(hostname, '.')))
		*tmp = '\0';

	if (register_input(&local, local_rets, LOCAL_RETS_NUM, 0) == -1) {
		specter_log(SPECTER_FATAL, "Couldn't register.\n");
		exit(EXIT_FAILURE);
	}
}

