// Global vars
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);
var cacheService = Components.classes["@uworks.net/speeddialcache;1"].getService().wrappedJSObject;

var speedDialBundle;

// Configuration parameters
var thumbnailTooltipTitle = true;
var thumbnailTooltipURL = true;
var showThumbnailOpenButton = true;
var showThumbnailReloadButton = true;
var showThumbnailDeassignButton = true;
var showThumbnailNewTabButton = true;
var showThumbnailBackgroundTabButton = true;
var showThumbnailNewWindowButton = true;
var showThumbnailEditButton = true;
var wheelScrollAmount = 10;
var enableCache = true;
var hideThumbnailNumbers;
var enableGroups = false;
var numGroups = 1;
var thumbnailDragDropExclude;
var thumbnailSequentialUpdate;
var screenColumns = 3;
var screenRows = 3;
var imageFormat = "png";
var marginVertical = -1;
var marginHorizontal = -1;
var numberThumbnails = 9;
var boardMinimumWidth;
var boardMaximumWidth;
var boardWidthModifier;
var boardWidthModifierType;
var boardMinimumHeight;
var boardMaximumHeight;
var boardHeightModifier;
var boardHeightModifierType;
var rightClickAction;
var oldResampling = false;
var colorizeTabs = false;
var rememberTabLastGroup = false;

// Global vars
var thumbnailCanvasWidth = 0;
var thumbnailCanvasHeight = 0;
var updateTimer = null;
var updateItems = new Array(9);
var updateLayout = false;
var boardWidth;
var boardHeight;
var isFirefox3 = false;
var currentGroup = 1;
var lastCreatedCell = null;
var topWindow = null;

function speeddialStartup() {
  // Load bundle
  speedDialBundle = document.getElementById("bundle_speeddial");

  cacheService.addInstance();

  // Detect version
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                        .getService(Components.interfaces.nsIXULAppInfo)
  var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                        .getService(Components.interfaces.nsIVersionComparator);
  // only if the platform version is 1.9 or greater
  if (versionChecker.compare(appInfo.platformVersion, "1.9a1") >= 0) {
    isFirefox3 = true;
  }
  
  // Load settings
  thumbnailTooltipTitle = gPref.getBoolPref("extensions.speeddial.thumbnailTooltipTitle");
  thumbnailTooltipURL = gPref.getBoolPref("extensions.speeddial.thumbnailTooltipURL");
  thumbnailDragDropExclude = gPref.getBoolPref("extensions.speeddial.thumbnailDragDropExclude");
  thumbnailSequentialUpdate = gPref.getBoolPref("extensions.speeddial.thumbnailSequentialUpdate");
  showThumbnailReloadButton = gPref.getBoolPref("extensions.speeddial.showThumbnailReloadButton");
  showThumbnailDeassignButton = gPref.getBoolPref("extensions.speeddial.showThumbnailDeassignButton");
  showThumbnailNewTabButton = gPref.getBoolPref("extensions.speeddial.showThumbnailNewTabButton");
  showThumbnailNewWindowButton = gPref.getBoolPref("extensions.speeddial.showThumbnailNewWindowButton");
  showThumbnailOpenButton = gPref.getBoolPref("extensions.speeddial.showThumbnailOpenButton");
  showThumbnailBackgroundTabButton = gPref.getBoolPref("extensions.speeddial.showThumbnailBackgroundTabButton");
  showThumbnailEditButton = gPref.getBoolPref("extensions.speeddial.showThumbnailEditButton");
  enableCache = gPref.getBoolPref("extensions.speeddial.enableCache");
  wheelScrollAmount = gPref.getIntPref("extensions.speeddial.wheelScrollAmount");
  screenRows = gPref.getIntPref("extensions.speeddial.rows");
  screenColumns = gPref.getIntPref("extensions.speeddial.columns");
  boardMinimumWidth = gPref.getIntPref("extensions.speeddial.minimumWidth");
  boardWidthModifier = gPref.getIntPref("extensions.speeddial.widthModifier");
  boardWidthModifierType = gPref.getIntPref("extensions.speeddial.widthModifierType");
  boardMaximumWidth = gPref.getIntPref("extensions.speeddial.maximumWidth");
  boardMinimumHeight = gPref.getIntPref("extensions.speeddial.minimumHeight");
  boardHeightModifier = gPref.getIntPref("extensions.speeddial.heightModifier");
  boardHeightModifierType = gPref.getIntPref("extensions.speeddial.heightModifierType");
  boardMaximumHeight = gPref.getIntPref("extensions.speeddial.maximumHeight");
  boardMaximumHeight = gPref.getIntPref("extensions.speeddial.maximumHeight");
  rightClickAction = gPref.getIntPref("extensions.speeddial.rightClickAction");
  hideThumbnailNumbers = gPref.getBoolPref("extensions.speeddial.hideThumbnailNumbers");
  enableGroups = gPref.getBoolPref("extensions.speeddial.enableGroups");
  imageFormat = gPref.getCharPref("extensions.speeddial.imageFormat");
  if (enableGroups) {
    numGroups = gPref.getIntPref("extensions.speeddial.numGroups");
    colorizeTabs = gPref.getBoolPref("extensions.speeddial.colorizeTabs");
    rememberTabLastGroup = gPref.getBoolPref("extensions.speeddial.rememberTabLastGroup");
    // Show tab strip
    document.getElementById("speeddialTabbox-tabs").setAttribute("collapsed", false);
  }
  if (numGroups < 1) numGroups = 1;
  if (currentGroup >= numGroups) {
    currentGroup = numGroups;
  }
  
  numberThumbnails = screenRows * screenColumns * numGroups;
  
  if (!isFirefox3) {
    oldResampling = gPref.getBoolPref("extensions.speeddial.oldResampling");
  }
  
  if (gPref.getBoolPref("extensions.speeddial.mouseOverThumbnailButtons")) {
    document.getElementById("speeddialTabbox").setAttribute("hideThumbButtons", "true");
  }
  
  if (gPref.getBoolPref("extensions.speeddial.hideThumbnailIcons")) {
    document.getElementById("speeddialTabbox").setAttribute("hideThumbIcons", "true");
  }

  if (enableGroups) {
    var speedDialTab = null;
    if (rememberTabLastGroup) {
      // Set top window
      topWindow = QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIWebNavigation).QueryInterface(Components.interfaces.nsIDocShellTreeItem).rootTreeItem.QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIDOMWindow);
    
      var tabbrowser = topWindow.getBrowser();
      for (var i = 0; (i < tabbrowser.mTabContainer.childNodes.length) && !speedDialTab; i++) {
        var tab = tabbrowser.mTabContainer.childNodes[i];
        if (tab.linkedBrowser.contentWindow == window) {
          speedDialTab = tab;
        }
      }
    }
    if ((speedDialTab) && (speedDialTab.hasAttribute("speedDialLastGroup"))) {
      currentGroup = parseInt(speedDialTab.getAttribute("speedDialLastGroup"));
    } else {
      // Retrieve current group if necessary
      if (window.location.search) {
        var groupParameter = window.location.search.substr("?group=".length, window.location.search.length);
        currentGroup = parseInt(groupParameter);
      }
    }
  }
  
  // Generate content
  try {
  generateContent();
  } catch (e) { alert(e); }

  calculateBoardSize();
  restoreCanvasSize(false);

  // Register observers
  SpeedDialPrefObserver.addPrefObserver();
  window.addEventListener("resize", sizeChanged, false);
  window.addEventListener("mousedown", windowMouseDown, true);

  /*
  if (gPref.getBoolPref("extensions.speeddial.clearURLBarOnLoad")) {
    // Save selection ranges
    var parentWindow = getParentWindow();
    var urlBar = parentWindow.document.getElementById("urlbar");
    selectionStart = urlBar.selectionStart;
    selectionEnd = urlBar.selectionEnd;
  }
  */
  
  //setTimeout(speeddialAfterLoad, 0);
}
/*
function speeddialAfterLoad() {
  var parentWindow = getParentWindow();
  var urlBar = parentWindow.document.getElementById("urlbar");

  if (gPref.getBoolPref("extensions.speeddial.clearURLBarOnLoad")) {
    urlBar.editor.undo(2);
    // Restore selection ranges
    urlBar.setSelectionRange(selectionStart, selectionEnd);
  }

  if (gPref.getBoolPref("extensions.speeddial.focusURLBarOnLoad")) {
    setTimeout(speeddialFocusURLBar, 0);
  }
}
*/

function tabDragOverEvent(event) {
  var found = false;
  var foundNode = null;
  var currentNode = event.target;
  
  while ((currentNode.parentNode) && !found) {
    if (currentNode.localName == "tab") {
      found = true;
      foundNode = currentNode;
    }
    currentNode = currentNode.parentNode;
  }
  if (found) {
    if (currentGroup != foundNode.getAttribute("group")) {
      var tabContainer = document.getElementById("speeddialTabbox-tabs");
      tabContainer.selectedItem = foundNode;
    }
  }
}

function generateContent() {
  var tabContainer = document.getElementById("speeddialTabbox-tabs");
  var panelContainer = document.getElementById("speeddialTabbox-panelContainer");
  var selectedPanel = null;

  for (var b=1; b<=numGroups; b++) {
    // Create tab
    var newTab = document.createElement("tab");
    var newTabPanel = document.createElement("tabpanel");
    
    newTab.setAttribute("group", b);
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + b + "-title")) {
      newTab.setAttribute("label", gPref.getComplexValue("extensions.speeddial.group-" + b + "-title", Components.interfaces.nsISupportsString).data);
    } else {
      newTab.setAttribute("label", speedDialBundle.getFormattedString("untitledGroup.label", [b]));
    }
    
    newTab.setAttribute("ondragover", "tabDragOverEvent(event);");
    
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + b + "-backgroundColor")) {
      newTabPanel.style.backgroundColor = gPref.getCharPref("extensions.speeddial.group-" + b + "-backgroundColor") + " !important";
      if (colorizeTabs) {
        newTab.style.backgroundColor = newTabPanel.style.backgroundColor;
        newTab.style.MozAppearance = "none !important";
      }
    }

    if (gPref.prefHasUserValue("extensions.speeddial.group-" + b + "-textColor")) {
      newTabPanel.style.color = gPref.getCharPref("extensions.speeddial.group-" + b + "-textColor") + " !important";
      if (colorizeTabs) {
        newTab.style.color = gPref.getCharPref("extensions.speeddial.group-" + b + "-textColor") + " !important";
      }
    }
    
    var newGrid = document.createElement("grid");
    newGrid.setAttribute("flex", 1);
    
    var columns = document.createElement("columns");
    var column = document.createElement("column");
    var rows = document.createElement("rows");
    
    column.setAttribute("flex", 1);
    newTab.linkedPanel = "speedDialPanel" + b;
    newTabPanel.setAttribute("id", newTab.linkedPanel);
    newTabPanel.setAttribute("group", b);
    rows.setAttribute("id", newTab.linkedPanel + "-rows");

    columns.appendChild(column);
    newGrid.appendChild(columns);
    newGrid.appendChild(rows);
    newTabPanel.appendChild(newGrid);
    panelContainer.appendChild(newTabPanel);
    tabContainer.appendChild(newTab);
    
    if (b == currentGroup) {
      newTab.setAttribute("selected", "true");
      selectedPanel = newTabPanel;
    }
  }

  // Generate cells
  generateTabCells(currentGroup);
  
  // Select new panel
  panelContainer.selectedPanel = selectedPanel;
}

function generateTabCells(selectedGroup) {
  var targetPanelRows = document.getElementById("speedDialPanel" + selectedGroup + "-rows");
  var currentDial = (selectedGroup - 1) * screenRows * screenColumns + 1;
  var cellMaxWidth = Math.floor(100/screenColumns);
  for (var c=1; c<=screenRows; c++) {
    var newRow = document.createElement("row");
    newRow.setAttribute("flex", 1);
    var newRowBox = document.createElement("hbox");
    newRowBox.setAttribute("flex", 1);
    for (var d=1; d<=screenColumns; d++) {
      var newCell = document.createElement("box");
      newCell.setAttribute("id", "speeddial" + currentDial);
      newCell.setAttribute("speeddial", currentDial);
      newCell.setAttribute("class", "speeddialThumb");
      if (rightClickAction == 6) {
        newCell.setAttribute("context", "thumbMenu");
      }
      newCell.style.maxWidth = cellMaxWidth + "%";
      newCell.style.width = newCell.style.maxWidth;
      newCell.style.minWidth = newCell.style.maxWidth;
      newRowBox.appendChild(newCell);
      lastCreatedCell = newCell;
      currentDial++;
    }
    newRow.appendChild(newRowBox);
    targetPanelRows.appendChild(newRow);
  }
  document.getElementById("speedDialPanel" + selectedGroup).setAttribute("initiated", true);
}

function checkSelectedPanel() {
  var panelContainer = document.getElementById("speeddialTabbox-panelContainer");

  if (currentGroup != (panelContainer.selectedIndex + 1)) {
    currentGroup = panelContainer.selectedIndex + 1;

    if (!panelContainer.selectedPanel.hasAttribute("initiated")) {
      generateTabCells(currentGroup);
    }
    sizeChanged();
  }
  /*
  var initialDial = currentGroup * screenRows * screenColumns + 1;
  // Update thumbnails
  for (var c=initialDial; c<=(initialDial + screenRows * screenColumns); c++) {
    var currentThumbnail = document.getElementById("speeddial" + c);
    if (currentThumbnail) {
      currentThumbnail.updateThumbnail();
    }
    updateItems[c] = false;
  }
  */
}

function destroyContent() {
  var tabContainer = document.getElementById("speeddialTabbox-tabs");
  var panelContainer = document.getElementById("speeddialTabbox-panelContainer");

  for (var c=tabContainer.childNodes.length-1; c>=0; c--) {
    var currentElement = tabContainer.childNodes[c];
    if (currentElement.localName == "tab") {
      var targetPanel = document.getElementById(currentElement.linkedPanel);
      
      // Take out tab
      panelContainer.removeChild(targetPanel);
      tabContainer.removeChild(currentElement);
    }
  }
}

function checkThumbnailDragDropExcludeCanvas(event) {
  if (thumbnailDragDropExclude) {
    event.stopPropagation();
  }
}

function speeddialFocusURLBar() {
  var parentWindow = getParentWindow();
  var urlBar = parentWindow.document.getElementById("urlbar");
  urlBar.focus();
  urlBar.select();
}

function speeddialUnload() {
  // Unregister observers
  SpeedDialPrefObserver.removePrefObserver();
  window.removeEventListener("resize", sizeChanged, false);
  window.removeEventListener("mousedown", windowMouseDown, true);

  cacheService.removeInstance();
  if (!enableCache) {
    if (cacheService.getNumberInstances() <= 0) {
      // Nullify cache
      for (var c=0; c<numberThumbnails; c++) {
        cacheService.setImage(null, c);
      }
    }
  }
  
  if (rememberTabLastGroup) {
    // Remember current group
    var tabbrowser = topWindow.getBrowser();
    var foundTab = false;
    for (var i = 0; (i < tabbrowser.mTabContainer.childNodes.length) && !foundTab; i++) {
      var tab = tabbrowser.mTabContainer.childNodes[i];
      if (tab.linkedBrowser.contentWindow == window) {
        tab.setAttribute("speedDialLastGroup", currentGroup);
        foundTab = true;
      }
    }
  }
}

function restoreCanvasSize(sequentialUpdate) {
//  if (marginHorizontal < 0) {
    var canvasBox = document.getBoxObjectFor(lastCreatedCell.getCanvasBox());
    thumbnailCanvasWidth = canvasBox.width;
    thumbnailCanvasHeight = canvasBox.height;
    marginHorizontal = boardWidth - screenColumns * thumbnailCanvasWidth;
    marginVertical = boardHeight - screenRows * thumbnailCanvasHeight;
//  }

//  if (thumbnailCanvasWidth < 0) {
//    thumbnailCanvasWidth = Math.floor((boardWidth - marginHorizontal) / screenColumns);
//    thumbnailCanvasHeight = Math.floor((boardHeight - marginVertical) / screenRows);
//  }

  // Update thumbnails for current group
  var initialDial = (currentGroup - 1) * screenRows * screenColumns + 1;
  // Update thumbnails
  for (var c=initialDial; c<=(initialDial + screenRows * screenColumns); c++) {
    var currentThumbnail = document.getElementById("speeddial" + c);
    if (currentThumbnail) {
      currentThumbnail.updateThumbnail();
    }
    updateItems[c] = false;
  }
}

function nullifyCanvasSize() {
  for (var c=1; c<=numberThumbnails; c++) {
    var currentThumbnail = document.getElementById("speeddial" + c);
    if (currentThumbnail) {
      currentThumbnail.nullifyCanvas();
    }
  }
}

function updatePendingItems() {
  for (var c=1; c<=numberThumbnails; c++) {
    if (updateItems[c]) {
      var currentThumbnail = document.getElementById("speeddial" + c);
      if (currentThumbnail) {
        currentThumbnail.updateThumbnail();
      }
      updateItems[c] = false;
    }
  }
}

function openURL(url, where) {
  if (!url) return;

  var parentWindow = getParentWindow();
  if (where == "current") {
    document.location = url;
  } else {
    parentWindow.openUILinkIn(url, where);
  }
}

function contextEditGroup() {
  var found = false;
  var foundIndex = -1;
  var currentNode = document.popupNode;
  
  while ((currentNode.parentNode) && !found) {
    if (currentNode.localName == "tab") {
      found = true;
      foundIndex = currentNode.getAttribute("group");
    }
    currentNode = currentNode.parentNode;
  }
  if (found) {
    openDialog("chrome://speeddial/content/editGroup.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [ foundIndex ]);
  }
}

function contextAddGroup() {
  openDialog("chrome://speeddial/content/editGroup.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [ -1 ]);
}

function contextRemoveGroup() {
  var found = false;
  var foundIndex = -1;
  var currentNode = document.popupNode;
  
  while ((currentNode.parentNode) && !found) {
    if (currentNode.localName == "tab") {
      found = true;
      foundIndex = parseInt(currentNode.getAttribute("group"));
    }
    currentNode = currentNode.parentNode;
  }
  if (found) {
    var totalGroups = gPref.getIntPref("extensions.speeddial.numGroups");
    
    if (totalGroups < 2) return;
    
    // Move data
    for (var c=foundIndex; c<totalGroups; c++) {
      // Move title
      if (gPref.prefHasUserValue("extensions.speeddial.group-" + (c+1) + "-title")) {
        gPref.setComplexValue("extensions.speeddial.group-" + c + "-title", Components.interfaces.nsISupportsString, gPref.getComplexValue("extensions.speeddial.group-" + (c+1) + "-title", Components.interfaces.nsISupportsString));
        gPref.clearUserPref("extensions.speeddial.group-" + (c+1) + "-title");
      } else if (gPref.prefHasUserValue("extensions.speeddial.group-" + c + "-title")) {
        gPref.clearUserPref("extensions.speeddial.group-" + c + "-title");
      }
      
      // Move background color
      if (gPref.prefHasUserValue("extensions.speeddial.group-" + (c+1) + "-backgroundColor")) {
        gPref.setCharPref("extensions.speeddial.group-" + c + "-backgroundColor", gPref.getCharPref("extensions.speeddial.group-" + (c+1) + "-backgroundColor"));
        gPref.clearUserPref("extensions.speeddial.group-" + (c+1) + "-backgroundColor");
      } else if (gPref.prefHasUserValue("extensions.speeddial.group-" + c + "-backgroundColor")) {
        gPref.clearUserPref("extensions.speeddial.group-" + c + "-backgroundColor");
      }
      
      // Move text color
      if (gPref.prefHasUserValue("extensions.speeddial.group-" + (c+1) + "-textColor")) {
        gPref.setCharPref("extensions.speeddial.group-" + c + "-textColor", gPref.getCharPref("extensions.speeddial.group-" + (c+1) + "-textColor"));
        gPref.clearUserPref("extensions.speeddial.group-" + (c+1) + "-textColor");
      } else if (gPref.prefHasUserValue("extensions.speeddial.group-" + c + "-textColor")) {
        gPref.clearUserPref("extensions.speeddial.group-" + c + "-textColor");
      }
      
    }
    
    gPref.setIntPref("extensions.speeddial.numGroups", totalGroups - 1);
    if (currentGroup == totalGroups) {
      currentGroup--;
    }
  }
}

function editThumbnail(thumbNumber) {
  openDialog("chrome://speeddial/content/editDial.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [ thumbNumber ]);
}

function refreshThumbnail(thumbNumber) {
  gPref.setBoolPref("extensions.speeddial.thumbnail-" + thumbNumber + "-manualrefresh", true);
}

function refreshAllThumbnails() {
  for (var c=0; c<=numberThumbnails; c++) {
    if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + c + "-url")) {
      gPref.setBoolPref("extensions.speeddial.thumbnail-" + c + "-manualrefresh", true);
    }
  }
}

function showingThumbnailTooltip(event) {
  event.stopPropagation();

  var currentTitle = document.getElementById("thumbnailTooltipTitle");
  var currentURL = document.getElementById("thumbnailTooltipURL");
  var showTooltip = false;

  var targetNode = document.tooltipNode;
  while (targetNode && (!targetNode.parentThumbnail)) {
    targetNode = targetNode.parentNode;
  }
  if (targetNode.parentThumbnail)
    targetNode = targetNode.parentThumbnail;

  if (thumbnailTooltipTitle && targetNode.hasAttribute("thumbnailTitle")) {
    currentTitle.removeAttribute("hidden");
    currentTitle.value = targetNode.getAttribute("thumbnailTitle");
    showTooltip = true;
  } else {
    currentTitle.setAttribute("hidden", true);
  }

  if (thumbnailTooltipURL && targetNode.hasAttribute("thumbnailURL")) {
    currentURL.removeAttribute("hidden");
    currentURL.value = targetNode.getAttribute("thumbnailURL");
    showTooltip = true;
  } else {
    currentURL.setAttribute("hidden", true);
  }
  return showTooltip;
}

function getParentWindow() {
  if (window.opener) {
    return window.opener;
  } else {
    return QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIWebNavigation).QueryInterface(Components.interfaces.nsIDocShellTreeItem).rootTreeItem.QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIDOMWindow);
  }
}

function getThumbnailImageURL(thumbnailNumber) {
  var file = Components.classes["@mozilla.org/file/directory_service;1"]
                     .getService(Components.interfaces.nsIProperties)
                     .get("ProfD", Components.interfaces.nsIFile);
  var fileExtension = imageFormat;
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbnailNumber + "-format")) {
    fileExtension = gPref.getCharPref("extensions.speeddial.thumbnail-" + thumbnailNumber + "-format");
  }
  file.append(SpeedDialUtils.thumbFolder);
  if (!gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbnailNumber + "-lastsaved")) {
    file.append("thumbnail-" + thumbnailNumber + "." + fileExtension);
  } else {
    file.append("thumbnail-" + thumbnailNumber + "-" + gPref.getCharPref("extensions.speeddial.thumbnail-" + thumbnailNumber + "-lastsaved") + "." + fileExtension);
  }
  if (file.exists() && !file.isDirectory()) {
    var ios = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);
    return ios.newFileURI(file).spec;
  } else {
    return null;
  }
}

function moveThumbnailImage(originalNumber, destinationNumber) {
  var file = Components.classes["@mozilla.org/file/directory_service;1"]
                     .getService(Components.interfaces.nsIProperties)
                     .get("ProfD", Components.interfaces.nsIFile);
  file.append(SpeedDialUtils.thumbFolder);
  var thumbFolder = file.clone();

  var fileExtension = imageFormat;
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalNumber + "-format")) {
    fileExtension = gPref.getCharPref("extensions.speeddial.thumbnail-" + originalNumber + "-format");
  } else if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + destinationNumber + "-format")) {
    fileExtension = gPref.getCharPref("extensions.speeddial.thumbnail-" + destinationNumber + "-format");
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalNumber + "-lastsaved")) {
    file.append("thumbnail-" + originalNumber + "-" + gPref.getCharPref("extensions.speeddial.thumbnail-" + originalNumber + "-lastsaved") + "." + fileExtension);
  } else {
    file.append("thumbnail-" + originalNumber + "." + fileExtension);
  }

  var destFileName;
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + destinationNumber + "-lastsaved")) {
    destFileName = "thumbnail-" + destinationNumber + "-" + gPref.getCharPref("extensions.speeddial.thumbnail-" + destinationNumber + "-lastsaved") + "." + fileExtension;
  } else {
    destFileName = "thumbnail-" + destinationNumber + "." + fileExtension;
  }
//alert("file: " + file.path + ", to: " + destFileName);
  if (file.exists() && !file.isDirectory()) {
    file.moveTo(thumbFolder, destFileName);
  }
}

function copyThumbnailData(originalDial, targetDial) {
  // Copy data
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-url")) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url", gPref.getCharPref("extensions.speeddial.thumbnail-" + originalDial + "-url"));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-icon")) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-icon", gPref.getCharPref("extensions.speeddial.thumbnail-" + originalDial + "-icon"));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-label")) {
    gPref.setComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, gPref.getComplexValue("extensions.speeddial.thumbnail-" + originalDial + "-label", Components.interfaces.nsISupportsString));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-lastsaved")) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-lastsaved", gPref.getCharPref("extensions.speeddial.thumbnail-" + originalDial + "-lastsaved"));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-dynamictitle")) {
    gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle", gPref.getBoolPref("extensions.speeddial.thumbnail-" + originalDial + "-dynamictitle"));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-refreshinterval")) {
    gPref.setIntPref("extensions.speeddial.thumbnail-" + targetDial + "-refreshinterval", gPref.getIntPref("extensions.speeddial.thumbnail-" + originalDial + "-refreshinterval"));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-manualrefresh")) {
    gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-manualrefresh", gPref.getBoolPref("extensions.speeddial.thumbnail-" + originalDial + "-manualrefresh"));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-format")) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-format", gPref.getCharPref("extensions.speeddial.thumbnail-" + originalDial + "-format"));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-backgroundcolor")) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-backgroundcolor", gPref.getCharPref("extensions.speeddial.thumbnail-" + originalDial + "-backgroundcolor"));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-layout")) {
    gPref.setIntPref("extensions.speeddial.thumbnail-" + targetDial + "-layout", gPref.getIntPref("extensions.speeddial.thumbnail-" + originalDial + "-layout"));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-cropping")) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping", gPref.getCharPref("extensions.speeddial.thumbnail-" + originalDial + "-cropping"));
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalDial + "-thumbnailurl")) {
    gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl", gPref.getCharPref("extensions.speeddial.thumbnail-" + originalDial + "-thumbnailurl"));
  }
}

function copyThumbnailImage(originalNumber, destinationNumber) {
  var file = Components.classes["@mozilla.org/file/directory_service;1"]
                     .getService(Components.interfaces.nsIProperties)
                     .get("ProfD", Components.interfaces.nsIFile);
  file.append(SpeedDialUtils.thumbFolder);
  var thumbFolder = file.clone();

  var fileExtension = imageFormat;
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalNumber + "-format")) {
    fileExtension = gPref.getCharPref("extensions.speeddial.thumbnail-" + originalNumber + "-format");
  } else if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + destinationNumber + "-format")) {
    fileExtension = gPref.getCharPref("extensions.speeddial.thumbnail-" + destinationNumber + "-format");
  }  

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + originalNumber + "-lastsaved")) {
    file.append("thumbnail-" + originalNumber + "-" + gPref.getCharPref("extensions.speeddial.thumbnail-" + originalNumber + "-lastsaved") + "." + fileExtension);
  } else {
    file.append("thumbnail-" + originalNumber + "." + fileExtension);
  }

  var destFileName;
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + destinationNumber + "-lastsaved")) {
    destFileName = "thumbnail-" + destinationNumber + "-" + gPref.getCharPref("extensions.speeddial.thumbnail-" + destinationNumber + "-lastsaved") + "." + fileExtension;
  } else {
    destFileName = "thumbnail-" + destinationNumber + "." + fileExtension;
  }

  if (file.exists() && !file.isDirectory()) {
    file.copyTo(thumbFolder, destFileName);
  }
}


function getThumbnailCanvasWidth() {
  return thumbnailCanvasWidth;
}

function getThumbnailCanvasHeight() {
  return thumbnailCanvasHeight;
}

function checkShouldShowContextMenu(thumbNumber) {
  var thumbMenu = document.getElementById("thumbMenu");
  var showItems;
  
  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + thumbNumber + "-url")) {
    showItems = true;
  } else {
    showItems = false;
  }
  
  for (var c=0; c<thumbMenu.childNodes.length; c++) {
    if ((thumbMenu.childNodes[c].getAttribute("id") != "context-edit") &&
        (thumbMenu.childNodes[c].getAttribute("id") != "context-refreshall")) {
      thumbMenu.childNodes[c].setAttribute("hidden", !showItems);
    }
  }
  
  return true;
}

function sizeChanged() {
/*
  var innerBox = document.getElementById("speeddialBox");
  
  if ((innerBox.boxObject.width < boardWidth) || (innerBox.boxObject.height < boardHeight)) {
    boardWidth = innerBox.boxObject.width;
    boardHeight = innerBox.boxObject.height;
    nullifyCanvasSize();
    setTimeout(restoreCanvasSize, 0);
  } else {
    restoreCanvasSize();
  }
*/
//  nullifyCanvasSize();
//  setTimeout(restoreCanvasSize, 0, false);
  thumbnailCanvasWidth = -1;
  thumbnailCanvasHeight = -1;

  calculateBoardSize();

  restoreCanvasSize(false);
}

function windowMouseDown(el) {
  if (el.button == 1) {
    el.stopPropagation();
//    el.preventDefault();
  }
}

var SpeedDialPrefObserver = 
{
  prefObserver : {
    observe: function(subject, topic, data) {
    // subject is the nsIPrefBranch we're observing (after appropriate QI)
    // data is the name of the pref that's been changed (relative to subject)
    var updateAllThumbnails = false;
    var updatePendingThumbnails = false;

    if (topic == "nsPref:changed") {
      if (data.indexOf("extensions.speeddial.thumbnail-") == 0) {
        // A thumbnail is updated!
        var number = (data.split("-", 2))[1];
        if (number <= numberThumbnails) {
          updateItems[number] = true;
          updatePendingThumbnails = true;
        }
      } else {
        var updateSize = false;
        if (data == "extensions.speeddial.thumbnailTooltipTitle") {
          thumbnailTooltipTitle = gPref.getBoolPref("extensions.speeddial.thumbnailTooltipTitle");
        } else if (data == "extensions.speeddial.thumbnailTooltipTitle") {
          thumbnailTooltipURL = gPref.getBoolPref("extensions.speeddial.thumbnailTooltipURL");
        } else if (data == "extensions.speeddial.thumbnailDragDropExclude") {
          thumbnailDragDropExclude = gPref.getBoolPref("extensions.speeddial.thumbnailDragDropExclude");
        } else if (data == "extensions.speeddial.showThumbnailReloadButton") {
          showThumbnailReloadButton = gPref.getBoolPref("extensions.speeddial.showThumbnailReloadButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailDeassignButton") {
          showThumbnailDeassignButton = gPref.getBoolPref("extensions.speeddial.showThumbnailDeassignButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailNewTabButton") {
          showThumbnailNewTabButton = gPref.getBoolPref("extensions.speeddial.showThumbnailNewTabButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailNewWindowButton") {
          showThumbnailNewWindowButton = gPref.getBoolPref("extensions.speeddial.showThumbnailNewWindowButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailEditButton") {
          showThumbnailEditButton = gPref.getBoolPref("extensions.speeddial.showThumbnailEditButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailBackgroundTabButton") {
          showThumbnailBackgroundTabButton = gPref.getBoolPref("extensions.speeddial.showThumbnailBackgroundTabButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.showThumbnailOpenButton") {
          showThumbnailOpenButton = gPref.getBoolPref("extensions.speeddial.showThumbnailOpenButton");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.whellScrollAmount") {
          whellScrollAmount = gPref.getIntPref("extensions.speeddial.whellScrollAmount");
        } else if (data == "extensions.speeddial.enableCache") {
          enableCache = gPref.getBoolPref("extensions.speeddial.enableCache");
        } else if (data == "extensions.speeddial.rows") {
          screenRows = gPref.getIntPref("extensions.speeddial.rows");
          updateAllThumbnails = true;
          updateLayout = true;
          numberThumbnails = screenRows * screenColumns;
        } else if (data == "extensions.speeddial.columns") {
          screenColumns = gPref.getIntPref("extensions.speeddial.columns");
          updateAllThumbnails = true;
          updateLayout = true;
          numberThumbnails = screenRows * screenColumns;
        } else if (data == "extensions.speeddial.minimumWidth") {
          boardMinimumWidth = gPref.getIntPref("extensions.speeddial.minimumWidth");
          updateSize = true;
        } else if (data == "extensions.speeddial.widthModifier") {
          boardWidthModifier = gPref.getIntPref("extensions.speeddial.widthModifier");
          updateSize = true;
        } else if (data == "extensions.speeddial.widthModifierType") {
          boardWidthModifierType = gPref.getIntPref("extensions.speeddial.widthModifierType");
          updateSize = true;
        } else if (data == "extensions.speeddial.maximumWidth") {
          boardMaximumWidth = gPref.getIntPref("extensions.speeddial.maximumWidth");
          updateSize = true;
        } else if (data == "extensions.speeddial.minimumHeight") {
          boardMinimumHeight = gPref.getIntPref("extensions.speeddial.minimumHeight");
          updateSize = true;
        } else if (data == "extensions.speeddial.heightModifier") {
          boardHeightModifier = gPref.getIntPref("extensions.speeddial.heightModifier");
          updateSize = true;
        } else if (data == "extensions.speeddial.heightModifierType") {
          boardHeightModifierType = gPref.getIntPref("extensions.speeddial.heightModifierType");
          updateSize = true;
        } else if (data == "extensions.speeddial.maximumHeight") {
          boardMaximumHeight = gPref.getIntPref("extensions.speeddial.maximumHeight");
          updateSize = true;
        } else if (data == "extensions.speeddial.rightClickAction") {
          rightClickAction = gPref.getIntPref("extensions.speeddial.rightClickAction");
          updateAllThumbnails = true;
          updateLayout = true;
        } else if (data == "extensions.speeddial.imageFormat") {
          imageFormat = gPref.getCharPref("extensions.speeddial.imageFormat");
        } else if ((data == "extensions.speeddial.oldResampling") && (!isFirefox3)) {
          oldResampling = gPref.getBoolPref("extensions.speeddial.oldResampling");
        } else if (data == "extensions.speeddial.mouseOverThumbnailButtons") {
          document.getElementById("speeddialTabbox").setAttribute("hideThumbButtons", gPref.getBoolPref("extensions.speeddial.mouseOverThumbnailButtons"));
        } else if (data == "extensions.speeddial.hideThumbnailNumbers") {
          hideThumbnailNumbers = gPref.getBoolPref("extensions.speeddial.hideThumbnailNumbers");
          updateAllThumbnails = true;
        } else if (data == "extensions.speeddial.hideThumbnailIcons") {
          document.getElementById("speeddialTabbox").setAttribute("hideThumbIcons", gPref.getBoolPref("extensions.speeddial.hideThumbnailIcons"));
        } else if (data == "extensions.speeddial.colorizeTabs") {
          colorizeTabs = gPref.getBoolPref("extensions.speeddial.colorizeTabs");
          if (enableGroups) {
            updateAllThumbnails = true;
            updateLayout = true;
          }
        } else if (data == "extensions.speeddial.enableGroups") {
          enableGroups = gPref.getBoolPref("extensions.speeddial.enableGroups");
          if (enableGroups) {
            document.getElementById("speeddialTabbox-tabs").setAttribute("collapsed", false);
            numGroups = gPref.getIntPref("extensions.speeddial.numGroups");
            colorizeTabs = gPref.getBoolPref("extensions.speeddial.colorizeTabs");
            if (numGroups < 1) numGroups = 1;
          } else {
            document.getElementById("speeddialTabbox-tabs").setAttribute("collapsed", true);
            numGroups = 1;
          }
          updateAllThumbnails = true;
          updateLayout = true;
        } else if (data == "extensions.speeddial.numGroups") {
          if (enableGroups) {
            numGroups = gPref.getIntPref("extensions.speeddial.numGroups");
            if (numGroups < 1) numGroups = 1;
            updateAllThumbnails = true;
            updateLayout = true;
          }
        } else if (data.indexOf("extensions.speeddial.group-") == 0) {
          var number = (data.split("-", 2))[1];
          if ((number == 1) || (enableGroups)) {
            updateAllThumbnails = true;
            updateLayout = true;
          }
        }
        
        if (updateSize) {
          sizeChanged();
        }
      }
      if (updateAllThumbnails) {
        for (var c=1; c<=numberThumbnails; c++) {
          updateItems[c] = true;
        }
      }

      if (updateAllThumbnails || updatePendingThumbnails) {
        if (updateTimer == null) {
          updateTimer = Components.classes["@mozilla.org/timer;1"].createInstance(Components.interfaces.nsITimer);
        }
        updateTimer.cancel();
        updateTimer.initWithCallback(SpeedDialPrefObserver.prefObserver, 100, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
      }
    }
  },

  QueryInterface : function (aIID) {
    if (aIID.equals(Components.interfaces.nsIObserver) || 
    aIID.equals(Components.interfaces.nsITimerCallback) ||
    aIID.equals(Components.interfaces.nsISupports) ||
    aIID.equals(Components.interfaces.nsISupportsWeakReference))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },

    notify: function(timer) {
      if (updateLayout) {
        destroyContent();
        generateContent();
        thumbnailCanvasWidth = -1;
        thumbnailCanvasHeight = -1;
        sizeChanged();
        restoreCanvasSize(false);
      } else {
        updatePendingItems();
      }
    }
  },

  addPrefObserver : function () {
    if (!gPref) return;
    gPref.addObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver, true);
  },

  removePrefObserver : function () {
    if (!gPref) return;
    gPref.removeObserver("extensions.speeddial.", SpeedDialPrefObserver.prefObserver);
  }
};

// Drag & drop
var thumbnailObserver = {
  onDragStart: function (evt,transferData,action) {
    transferData.data = createTransferDataForEntry(evt.currentTarget.getAttribute("speeddial"));
    if (transferData.data == null)
      return false;
    return true;
  },

  getSupportedFlavours : function () {
    var flavours = new FlavourSet();
    flavours.appendFlavour("text/x-speeddial-entry");
    flavours.appendFlavour("text/x-moz-url");
    flavours.appendFlavour("application/x-moz-file", "nsIFile");
    return flavours;
  },

  checkCanDrop: function(aEvent, aDragDropObserver) {
    // Allow drop on itself
    return true;
  },

  onDragOver: function (evt,flavour,session) {
  },

  onDragExit: function (aEvent, aDragSession) {
  },

  onDrop: function (aEvent,dropdata,session) {
try {
    const kDSIID      = Components.interfaces.nsIDragService;
    const kCopyAction = kDSIID.DRAGDROP_ACTION_COPY + kDSIID.DRAGDROP_ACTION_LINK;
    var moveIfPossible = !(session.dragAction & kCopyAction);

    var targetData = getSelectionFromXferData(session);
    var targetDial = aEvent.currentTarget.getAttribute("speeddial");

    if (targetData.type == "speedDialId") {
      var originalDial = targetData.value;

      if (originalDial == targetDial) {
        // If dropping on itself, just open it
        openURL(gPref.getCharPref("extensions.speeddial.thumbnail-" + originalDial + "-url"), "current");
        return;
      }

      if (moveIfPossible) {
        SpeedDialUtils.deassignThumbnail(numberThumbnails+1);
        SpeedDialUtils.deassignThumbnail(numberThumbnails+2);

        // Move image
        moveThumbnailImage(originalDial, numberThumbnails+1);
        moveThumbnailImage(targetDial, numberThumbnails+2);

        // Move data
        copyThumbnailData(originalDial, numberThumbnails+1);
        SpeedDialUtils.deassignThumbnail(originalDial);
        copyThumbnailData(targetDial, originalDial);
        SpeedDialUtils.deassignThumbnail(targetDial);
        copyThumbnailData(numberThumbnails+1, targetDial);

        SpeedDialUtils.deassignThumbnail(numberThumbnails+1);
        
        // Move images back again
        moveThumbnailImage(numberThumbnails+1, targetDial);
        moveThumbnailImage(numberThumbnails+2, originalDial);

        // Update cache...
        if (enableCache || oldResampling) {
          cacheService.setImage(getThumbnailImageURL(originalDial), originalDial);
          cacheService.setImage(getThumbnailImageURL(targetDial), targetDial);
        }
      } else {
        SpeedDialUtils.deassignThumbnail(targetDial);
        copyThumbnailData(originalDial, targetDial);
        // Copy image
        copyThumbnailImage(originalDial, targetDial);

        // Update cache...
        if (enableCache || oldResampling) {
          cacheService.setImage(getThumbnailImageURL(targetDial), targetDial);
        }
      }
    } else {
      // We're inserting a new URL if possible...
      var url = transferUtils.retrieveURLFromData(targetData.data, targetData.contentType);
        
      if (!url || !url.length || url.indexOf(" ", 0) != -1 ||
        /^\s*(javascript|data):/.test(url))
        return;
      
      // Just add the information...
      gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-url", url);

      var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
      str.data = "";
      gPref.setComplexValue("extensions.speeddial.thumbnail-" + targetDial + "-label", Components.interfaces.nsISupportsString, str);

      gPref.setCharPref("extensions.speeddial.thumbnail-" + targetDial + "-icon", "data:");
      gPref.setBoolPref("extensions.speeddial.thumbnail-" + targetDial + "-dynamictitle", true);

      // add time intervals
      var defaultRefreshInterval = gPref.getIntPref("extensions.speeddial.defaultRefreshInterval");
      if (defaultRefreshInterval > 0) {
        gPref.setIntPref("extensions.speeddial.thumbnail-" + targetDial + "-refreshinterval", defaultRefreshInterval);
      } else {
        if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-refreshinterval")) {
          gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-refreshinterval");
        }
      }

      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-lastsaved")) {
        gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-lastsaved");
      }

      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-format")) {
        gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-format");
      }

      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-backgroundcolor")) {
        gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-backgroundcolor");
      }

      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-layout")) {
        gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-layout");
      }

      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-cropping")) {
        gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-cropping");
      }

      if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl")) {
        gPref.clearUserPref("extensions.speeddial.thumbnail-" + targetDial + "-thumbnailurl");
      }
    }
} catch (e) {
alert(e);
}
  },

  canHandleMultipleItems: false
};

function getSelectionFromXferData(aDragSession) {
    var newValue = {};
    var trans = Components.classes["@mozilla.org/widget/transferable;1"]
                          .createInstance(Components.interfaces.nsITransferable);
    trans.addDataFlavor("text/x-speeddial-entry");
    trans.addDataFlavor("text/x-moz-url");
    trans.addDataFlavor("text/x-moz-file");
    trans.addDataFlavor("text/unicode");
    var uri, extra, rSource, rParent, parent;
    if (aDragSession.numDropItems > 0) {
      var bestFlavour = {}, dataObj = {}, len = {};
      aDragSession.getData(trans, 0);
      trans.getAnyTransferData(bestFlavour, dataObj, len);
      dataObj = dataObj.value.QueryInterface(Components.interfaces.nsISupportsString);
      if (dataObj) {
        var value = dataObj.data.substring(0, len.value);

        newValue.value = value;
        switch (bestFlavour.value) {
        case "text/x-speeddial-entry":
          newValue.type = "speedDialId";
          break;
        case "text/x-moz-url":
        case "text/x-moz-file":
        case "text/unicode":
          newValue.type = "url";
          newValue.contentType = bestFlavour.value;
          newValue.data = dataObj.data;
          break;
        }
      }
    }
    return newValue;
}

function createTransferDataForEntry(targetEntry) {
  var value;
  var title;

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetEntry + "-url")) {
    value = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetEntry + "-url");
  } else {
    return null;
  }

  if (gPref.prefHasUserValue("extensions.speeddial.thumbnail-" + targetEntry + "-label")) {
    title = gPref.getCharPref("extensions.speeddial.thumbnail-" + targetEntry + "-label");
  } else {
    title = "";
  }

  if (title == "") {
    title = speedDialBundle.getString("untitled.label");
  }
  
  var urlString = value + "\n" + title;
  var htmlString = "<a href=\"" + value + "\">" + title + "</a>";

  var data = new TransferData();
  data.addDataForFlavour("text/x-speeddial-entry", targetEntry);
  if ((value == "") || (value == "about:blank")) {
    data.addDataForFlavour("text/unicode", value);
  } else {
    data.addDataForFlavour("text/x-moz-url", urlString);
    data.addDataForFlavour("text/unicode", value);
    data.addDataForFlavour("text/html", htmlString);
  }

  return data;
}

function calculateBoardSize() {
  var innerBox = document.getElementById("speedDialPanel" + currentGroup);
  boardWidth = innerBox.boxObject.width;
  boardHeight = innerBox.boxObject.height;
  if (boardWidthModifierType == 0) {
    boardWidth = Math.floor(boardWidth * boardWidthModifier / 100);
  } else {
    boardWidth -= boardWidthModifier;
  }
  if ((boardMinimumWidth > 0) && (boardWidth < boardMinimumWidth)) {
    boardWidth = boardMinimumWidth;
  }
  if ((boardMaximumWidth > 0) && (boardWidth > boardMaximumWidth)) {
    boardWidth = boardMaximumWidth;
  }
  
  if (boardHeightModifierType == 0) {
    boardHeight = Math.floor(boardHeight * boardHeightModifier / 100);
  } else {
    boardHeight -= boardHeightModifier;
  }
  if ((boardMinimumHeight > 0) && (boardHeight < boardMinimumHeight)) {
    boardHeight = boardMinimumHeight;
  }
  if ((boardMaximumHeight > 0) && (boardHeight > boardMaximumHeight)) {
    boardHeight = boardMaximumHeight;
  }

  if (boardWidth > innerBox.boxObject.width) boardWidth = innerBox.boxObject.width;
  if (boardHeight > innerBox.boxObject.height) boardHeight = innerBox.boxObject.height;

  // Set border
  innerBox.style.paddingLeft = Math.floor((innerBox.boxObject.width - boardWidth) / 2) + "px";
  innerBox.style.paddingRight = innerBox.style.paddingLeft;
  innerBox.style.paddingTop = Math.floor((innerBox.boxObject.height - boardHeight) / 2) + "px";
  innerBox.style.paddingBottom = innerBox.style.paddingTop;
}

function groupContextShowing(event) {
  var currentNode = document.popupNode;
  var found = false;
  while ((currentNode.parentNode) && !found) {
    if (currentNode.localName == "tab") {
      found = true;
    }
    currentNode = currentNode.parentNode;
  }
  if (found) {
    // Show edit and remove
    document.getElementById("groupcontext-edit").setAttribute("hidden", false);
    var contextRemove = document.getElementById("groupcontext-remove");
    contextRemove.setAttribute("hidden", false);
    if (numGroups < 2) {
      contextRemove.setAttribute("disabled", true);
    } else {
      contextRemove.setAttribute("disabled", false);
    }
  } else {
    // hide edit and remove
    document.getElementById("groupcontext-edit").setAttribute("hidden", true);
    document.getElementById("groupcontext-remove").setAttribute("hidden", true);
  }
  return true;
}

window.addEventListener("load", function(e) { speeddialStartup() }, false);

