/* $Id: startalk.h,v 400.1 2002/07/25 08:43:16 sgifford Exp $ */

#ifndef STARTALK_H
#define STARTALK_H

#define MAX_ENTRIES 99

/* Raw writing functions */
int startalk_write_timeout(int serialfd, const char *buf, int size, int timeout);
int startalk_write(int serialfd, const char *buf, int size);
int startalk_writestr_timeout(int serialfd, const char *buf, int timeout);
int startalk_writestr(int serialfd, const char *buf);

/* Raw reading functions */
int startalk_read_timeout(int serialfd, char *buf, int nchars, int timeout);
int startalk_read(int serialfd, char *buf, int nchars);
int startalk_readfor(int serialfd, char *str);

/* Message processing functions */
int startalk_writemsg(int serialfd, char *msgbuf, int size);
int startalk_readmsg(int serialfd, char *msgbuf, int maxsize, int *msgsize);
int startalk_run_cmd(int serialfd, char *msgbuf, int size, char *resbuf, int *ressize);
int startalk_dump_cmd(int serialfd, char *msgbuf, int size);

/* Functions to set up and take down the connection to the phone. */
int startalk_open(char *devname);
void startalk_prepfor_exit(void);
void startalk_uninitialize(void);
int startalk_initialize(int serialfd);
int startalk_datamode(int serialfd);
int startalk_reset(int serialfd);

#endif /* STARTALK_H */
