/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen                                 *
 *   kde.sch@ttgen.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <klocale.h>
#include <kdebug.h>
#include <kcombobox.h>
#include "styleclockwidget/prefs.h"
#include "styleconfigdlg.h"
#include "style.h"
#include <kcolorbutton.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include "styleclockwidget/clockpaintview.h"

StyleConfigDialog::StyleConfigDialog(QWidget *parent, Prefs *prefs, ClockPaintView* clock) :
    KConfigDialog(parent, "stylecfgdlg", prefs, KDialogBase::Swallow,
        KDialogBase::Default | KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel,
        KDialogBase::Ok, false),
        prefs(prefs),
        clock(clock)
{
    styleWidget = new StyleConfigWidget(this);
    addPage(styleWidget, i18n("Themed clock"), QString::fromLatin1("style_settings"));
    styleWidget->show();
    connect(styleWidget->colorName, SIGNAL(activated(int)),
        this, SLOT(refreshCurrentProperty()));
    connect(styleWidget->color, SIGNAL(changed(const QColor&)), 
        this, SLOT(slotSaveCurrentProperty()));
    connect(styleWidget->useCustomColor, SIGNAL(toggled(bool)), 
        this, SLOT(slotSaveCurrentProperty()));
    props = clock->currentThemeProperties();
    updatePropertyList();
    kdDebug() << "Number of properties: " << props.size() << endl;
}

void StyleConfigDialog::slotSaveCurrentProperty()
{
    QString val = QString();
    if (styleWidget->useCustomColor->isChecked()) {
        val = styleWidget->color->color().name();
    }
    props[styleWidget->colorName->currentText()] = val;
    refreshCurrentProperty();
}

void StyleConfigDialog::updatePropertyList()
{
    styleWidget->colorName->clear();
    std::map<QString,QString>::iterator it;
    for (it = props.begin(); it != props.end(); ++it) {
        styleWidget->colorName->insertItem(it->first);
    }
    refreshCurrentProperty();
}

void StyleConfigDialog::refreshCurrentProperty()
{
    if (props.size() > 0) {
        styleWidget->colorGroup->setEnabled(true);
        QString val = props[styleWidget->colorName->currentText()];
        if (val == QString()) {
            styleWidget->useDefaultColor->setChecked(true);
            styleWidget->color->setEnabled(false);
        }
        else {
            styleWidget->useCustomColor->setChecked(true);
            styleWidget->color->setColor(QColor(val));
            styleWidget->color->setEnabled(true);
        }
    }
    else {
        styleWidget->colorGroup->setEnabled(false);
    }
}

void StyleConfigDialog::updateSettings()
{
    KConfigDialog::updateSettings();
    std::map<QString,QString>::iterator it;
    for (it = props.begin(); it != props.end(); ++it) {
        clock->setProperty(clock->currentTheme(), it->first, it->second);
    }
    emit settingsChanged();
    prefs->writeConfig();
    clock->reloadSettings();
}

bool StyleConfigDialog::hasChanged()
{
    bool ret = KConfigDialog::hasChanged() || props != clock->currentThemeProperties();
    kdDebug() << QString("hasChanged") << endl;
    return ret;
}

StyleConfigDialog::~StyleConfigDialog()
{
}

#include "styleconfigdlg.moc"
