// "Centurian" theme for StyleClock applet (for Kicker, KDE)
// version 0.9.4 (Dec 13, 2004)
// based on "glow" theme that came with StyleClock 0.5 
// and tweaked (hopefully beyond recognition) by Daniel "Suslik" D. <software@accentsolution.com>

//============================================================
//  NOTES:
//============================================================
// alignment scale: should be desired, resulting fraction of the display and be 0<scale<1
//	this is useful for setting different size digits in different places.
//	just draw your clock on paper, measure proportions from top-left and go.
//	Later convert it to pixels by screenHeight*scale
//	I prefer scaling proportionally based on vertical proportion of screenHeight to digit image.

//============================================================
//
//  Preparing functions and image coordinates
//
//============================================================

minCol = getColor("Minutes", 0.0, 0.0, 0.0);
hourCol = getColor("Hours", 0.4, 0.4, 0.4);
dayCol = getColor("Day", 0.1, 0.1, 0.1);
dateCol = getColor("Date", 0.2, 0.2, 0.2); // separate setting needed because scaling occurs after coloration > noticeable diff.

//numbers.png clipping sizes
numLtrSpacing=0.65;
numImgWide=25;
numImgTall=25; //note the symmetry of the clipping
numPicX=128;
numPicY=128;

//============================================================
//  A little magic with screen dimensions:
//============================================================
// heightRatio = length of heigth to one unit of width. (height/width)
xPadd=0.4; //The x starting point of the right-most element. (minutes in my case)
yPadd=0.2; //The y starting point of the lowest element. (minutes in my case)
heightRatio=((1-xPadd)*(numImgTall))/((1-yPadd)*(2.01*numLtrSpacing*numImgWide));
// dont waste your time trying to "read" the equasion above, it's simplyfied from a tripple division.
// it is ( x%SpaceObjOcupies / nominalXObjSize) / ( y%SpaceObjOcupies / nominalYObjSize)
// 2.01 is for extra pixels after 2 chars.
// heightRatio = 0.58; 

var picProps = new Array();
// s - character tag
// x,y - upper-left corner of char on *.png
// w,h - dimensions of char on *.png
// xSize,ySize - size of *.png
function defineNumPos(s,x,y,w,h,xSize,ySize) {
	o = new Object();
	o.texX = x/xSize; o.texY = y/ySize; o.texW = w/xSize; o.texH = h/ySize;
	picProps[s] = o;
	}

// numImgWide, numImgTall, numPicX, numPicY - defined up top.
defineNumPos("0", 3, 5, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos("1", 28, 5, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos("2", 53, 5, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos("3", 78, 5, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos("4", 102, 5, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos("5", 3, 45, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos("6", 28, 45, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos("7", 53, 45, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos("8", 78, 45, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos("9", 102, 45, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos(":", 2, 84, numImgWide, numImgTall, numPicX, numPicY);
defineNumPos("z", 0, 0, 1, 1, numPicX, numPicY); // empty space
defineNumPos("a", 26, 90, 17, 17, numPicX, numPicY);
defineNumPos("s", 45, 90, 24, 12, numPicX, numPicY); // Sunday
defineNumPos("m", 75, 90, 24, 12, numPicX, numPicY); // Monday
defineNumPos("t", 100, 90, 24, 12, numPicX, numPicY); // Tuesday
defineNumPos("w", 24, 112, 24, 12, numPicX, numPicY); // Wednesday
defineNumPos("h", 49, 112, 24, 12, numPicX, numPicY); // Thursday
defineNumPos("f", 71, 112, 24, 12, numPicX, numPicY); // Friday
defineNumPos("r", 98, 112, 24, 12, numPicX, numPicY); // Saturday


// strToDraw: hourString, minString, secStream, alarmString (string)
// fileName: "numbers.png", "misc.png"
// xScale,yScale: (pixels) (use screenHeight*scale to arrive there)
// colors: r,g,b (0-1)
// xPos, yPos: position on screen (pixels)
// xIncr,yIncr: x\y shift (pixels) (use ___ImgWide*scaleToScr*___LtrSpacing to arrive) (Keep one =0)
// anchor + rotate: later
function drawToScrn(strToDraw,fileName,xScale,yScale,xPos,yPos,xIncr,yIncr,red,green,blue,xAnchor,yAnchor,rot) {
//strToDraw="03";
//xScale=12.5;
//yScale=12.5;
//xPos=0;
//yPos=0;
//xIncr=0;
//yIncr=0;
for (n=0; n<strToDraw.length; ++n) {
	charProp = picProps[strToDraw[n]];
	numObj = defineLayer(fileName);
	numObj.scaleY = yScale;
	numObj.scaleX = xScale;
	numObj.texX = charProp.texX;
	numObj.texY = charProp.texY;
	numObj.texW = charProp.texW;
	numObj.texH = charProp.texH;
	numObj.moveX = xPos+xIncr*n;
	numObj.moveY = yPos+yIncr*n;
	numObj.anchorX = xAnchor;
	numObj.anchorY = yAnchor;
	numObj.rotate = rot;
	numObj.color.r = red;
	numObj.color.g = green;
	numObj.color.b = blue;
	}
}

//============================================================
//
//  Getting data and drawing it
//
//============================================================

// ===============================
// HOURS
// ===============================
// given: 
scaleToScreen = 0.55;
// of screen's vertical height. Hand picked.
// things we need: strToDraw,fileName,scaleX,scaleY,xPos,yPos,xIncr,yIncr
var hourString = "";
h = hour;
partOfDay="z";
if (use12HourFormat) {
	partOfDay="u";
	if (h>12) {
		h=h-12;
		partOfDay="v";
		}
	}
if (h<10) hourString = "0";
hourString = hourString + h.toString();
//hourString = "03";
// The Hours
pixScale = screenHeight*scaleToScreen; // pixels
spacing = pixScale*numLtrSpacing; // pixels
red = hourCol.r;
green = hourCol.g;
blue = hourCol.b;
drawToScrn(hourString,"numbers.png",pixScale,pixScale,0,1,spacing,0,red,green,blue,0,0,0);

// ===============================
// AM/PM
// ===============================
// given: 
// am/pm if needed.
// inheriting partOfDay from above (hours section)
/*
if (partOfDay!="z") {
	scaleToScreen = 0.25;
	pixScale = screenHeight*scaleToScreen; // pixels
	xPos = xPadd*screenWidth; //see "A Little screen dimension magic"
	yPos = (1-scaleToScreen)*screenHeight+1;
	red = hourCol.r;
	green = hourCol.g;
	blue = hourCol.b;
	drawToScrn(partOfDay,"numbers.png",pixScale,pixScale,0,1,spacing,0,red,green,blue,0,0,0);
	} // */

// ===============================
// MINUTES
// ===============================
// given: 
scaleToScreen = 1-yPadd; //see "A Little screen dimension magic"
// of screen's vertical height. Hand picked.
// things we need: strToDraw,fileName,scaleX,scaleY,xPos,yPos,xIncr,yIncr
var minString = "";
if (minute<10) minString = "0";
minString = minString + minute.toString();
//minString = "35";
pixScale = screenHeight*scaleToScreen; // pixels
spacing = pixScale*numLtrSpacing; // pixels
xPos = xPadd*screenWidth; //see "A Little screen dimension magic"
yPos = (1-scaleToScreen)*screenHeight+1;
red = minCol.r;
green = minCol.g;
blue = minCol.b;
//          strToDraw,fileName,     scaleX,  scaleY,  xPos,yPos,xIncr,  yIncr
drawToScrn(minString,"numbers.png",pixScale,pixScale,xPos,yPos,spacing,0,red,green,blue,0,0,0);

// ===============================
// SECONDS
// ===============================
// things we need: strToDraw,fileName,scaleX,scaleY,xPos,yPos,xIncr,yIncr
secString = ":";
if (showSeconds) {
	if ((Math.round(second/2))!=(second/2)) secString = "z";
//	secString = secString + second.toString();
}
scaleToScreen = 0.55;
// of screen's vertical height. Hand picked.
// things we need: strToDraw,fileName,scaleX,scaleY,xPos,yPos,xIncr,yIncr
pixScale = screenHeight*scaleToScreen; // pixels
//spacing = pixScale*numLtrSpacing; // pixels
xPos = 0.25*screenWidth;
yPos = (1-scaleToScreen+0.05)*screenHeight;
//          strToDraw,fileName,     scaleX,  scaleY,  xPos,yPos,xIncr,  yIncr
red = minCol.r;
green = minCol.g;
blue = minCol.b;
drawToScrn(secString,"numbers.png",pixScale,pixScale,xPos,yPos,0,0,red,green,blue,0,0,0);

// ===============================
// ALARM
// ===============================
// things we need: strToDraw,fileName,scaleX,scaleY,xPos,yPos,xIncr,yIncr

if (alarmActive) {
	alarmString = "a";
	//if (second < 10) secString = secString + "0";
	//secString = secString + second.toString();
	scaleToScreen = 0.4;
	// of screen's vertical height. Hand picked.
	// things we need: strToDraw,fileName,scaleX,scaleY,xPos,yPos,xIncr,yIncr
	//pixScale = picProps["a"].texW*scaleToScreen; // pixels
	pixScale = screenHeight*scaleToScreen;
	//pixScale = 17*scaleToScreen; // pixels
	//spacing = pixScale*numLtrSpacing; // pixels
	xPos = 0.015*screenWidth;
	yPos = 0.55*screenHeight;
	xCenter = 0.27;
	yCenter = 0.77;
	//          strToDraw,fileName,     scaleX,  scaleY,  xPos,yPos,xIncr,yIncr
	red = 1;
	green = 1;
	blue = 1;
	drawToScrn(alarmString,"numbers.png",pixScale,pixScale,xPos,yPos,0,0,red,green,blue,xCenter,yCenter,0);
	}

// ===============================
// WEEKDAY & DATE
// ===============================
// things we need: strToDraw,fileName,scaleX,scaleY,xPos,yPos,xIncr,yIncr /*
// since the showDate switch is not implemented yet, using showSeconds instead.
if (showDate) {
	// some common vars
	dateMidPnt=0.82;
	//
	weekDays=["m","t","w","h","f","r","s"];
	dayString = weekDays[dayOfWeek-1];
	//dayString = "r";
	scaleToScreen = 0.45;
	// of screen's vertical height. Hand picked.
	// things we need: strToDraw,fileName,scaleX,scaleY,xPos,yPos,xIncr,yIncr
	pixScale = screenHeight*scaleToScreen;
	//spacing = pixScale*numLtrSpacing; // pixels
	xPos=(screenWidth*dateMidPnt)-(pixScale+1);
	//xPos = 0.55*screenWidth;
	//xPos = 15;
	yPos = 0.05*screenHeight;
	red = dayCol.r;
	green = dayCol.g;
	blue = dayCol.b;
	//          strToDraw,fileName,     scaleX,  scaleY,  xPos,yPos,xIncr,yIncr
	drawToScrn(dayString,"numbers.png",pixScale,pixScale/2,xPos,yPos,0,0,red,green,blue,0,0,0);
	dateString = "";
	if (day < 10) dateString = dateString + "0";
	dateString = dateString + day.toString();
	//dateString = "03";
	scaleToScreen = 0.2;
	// of screen's vertical height. Hand picked.
	// things we need: strToDraw,fileName,scaleX,scaleY,xPos,yPos,xIncr,yIncr
	pixScale = screenHeight*scaleToScreen;
	//spacing = pixScale*numLtrSpacing; // pixels
	xPos = dateMidPnt*screenWidth;
	//xPos = 15;
	yPos = 0.05*screenHeight;
	spacing = pixScale*numLtrSpacing; // pixels
	red = dateCol.r;
	green = dateCol.g;
	blue = dateCol.b;
	//          strToDraw,fileName,     scaleX,  scaleY,  xPos,yPos,xIncr,yIncr
	drawToScrn(dateString,"numbers.png",pixScale,pixScale,xPos,yPos,spacing,0,red,green,blue,0,0,0);
	}

function widthForHeight(height) {
    return height/heightRatio;
}

function heightForWidth(width) {
    return width*heightRatio;
}