/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "StatusId.h"
#include "ColorId.h"

// we use the same chars here as subversion in:
// subversion/clients/cmdline/status.c:generate_status_code()

const StatusCode StatusCodes[] = 
{
  // general
  { StatusNone,          ColorNone,          sc::String(_n(" ")), sc::String(_n("none")) },
  { StatusUnversioned,   ColorUnversioned,   sc::String(_n("?")), sc::String(_n("unversioned")) },
  { StatusNormal,        ColorNormal,        sc::String(_n(" ")), sc::String(_n("unchanged")) },
  { StatusAdded,         ColorAdded,         sc::String(_n("A")), sc::String(_n("added")) },
  { StatusMissing,       ColorMissing,       sc::String(_n("!")), sc::String(_n("missing")) },
  { StatusDeleted,       ColorDeleted,       sc::String(_n("D")), sc::String(_n("deleted")) },
  { StatusReplaced,      ColorReplaced,      sc::String(_n("R")), sc::String(_n("replaced")) },
  { StatusModified,      ColorModified,      sc::String(_n("M")), sc::String(_n("modified")) },
  { StatusMerged,        ColorMerged,        sc::String(_n("G")), sc::String(_n("merged")) },
  { StatusConflicted,    ColorConflicted,    sc::String(_n("C")), sc::String(_n("conflicted")) },
  { StatusIgnored,       ColorIgnored,       sc::String(_n("I")), sc::String(_n("ignored")) },
  { StatusObstructed,    ColorObstructed,    sc::String(_n("~")), sc::String(_n("obstructed")) },
  { StatusExternal,      ColorExternal,      sc::String(_n("X")), sc::String(_n("external")) },
  { StatusIncomplete,    ColorIncomplete,    sc::String(_n("!")), sc::String(_n("incomplete")) },
  { StatusFallback,      ColorFallback,      sc::String(_n("-")), sc::String(_n("<fallback>")) },

  // working copy lock
  { StatusWcLockNone,    ColorNone,          sc::String(_n(" ")), sc::String(_n("not locked")) },
  { StatusWcLockLocked,  ColorNone,          sc::String(_n("L")), sc::String(_n("locked")) },

  // history
  { StatusHistoryNone,   ColorNone,          sc::String(_n(" ")), sc::String(_n("no history")) },
  { StatusHistory,       ColorNone,          sc::String(_n("+")), sc::String(_n("history")) },

  // switched
  { StatusSwitchedNo,    ColorNone,          sc::String(_n(" ")), sc::String(_n("not switched")) },
  { StatusSwitched,      ColorNone,          sc::String(_n("S")), sc::String(_n("switched")) },

  // switched
  { StatusUpToDateNo,    ColorNone,          sc::String(_n("*")), sc::String(_n("not up to date")) },
  { StatusUpToDate,      ColorNone,          sc::String(_n(" ")), sc::String(_n("up to date")) },

  // repository locks
  { StatusLockNone,      ColorNone,          sc::String(_n(" ")), sc::String(_n("not locked")) },
  { StatusLockLocked,    ColorNone,          sc::String(_n("K")), sc::String(_n("locked")) },
  { StatusLockStolen,    ColorNone,          sc::String(_n("T")), sc::String(_n("locked but stolen")) },
  { StatusLockOther,     ColorNone,          sc::String(_n("O")), sc::String(_n("locked in other wc")) },
  { StatusLockBroken,    ColorNone,          sc::String(_n("B")), sc::String(_n("not locked, broken")) }
};
