/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "MergeDialogCmd.h"
#include "../MergeDialog.h"
#include "../ExternProviderImpl.h"
#include "../BaseModel.h"
#include "../PostCmdResult.h"
#include "subcommander/Project.h"
#include "svn/Revision.h"

// qt
#include <qstring.h>
#include <qapplication.h>


MergeDialogCmd::MergeDialogCmd( QWidget* parent, ID tid, BaseModel* model,
  const Project* prj, bool enableSrc1, bool enableSrc2 )
: _parent(parent), _tid(tid), _model(model), _dlg(NULL), _prj(prj),
  _enableSrc1(enableSrc1), _enableSrc2(enableSrc2)
{
}

MergeDialogCmd::~MergeDialogCmd()
{
  delete _dlg;
}

void MergeDialogCmd::run( const QString& src1, const QString& src2,
  const svn::Revision* first, const svn::Revision* second, const QString& dst )
{
  _dlg = new MergeDialog( _model->getModel(),
    new ExternProviderImpl(_model->getModel()), _parent );

  connect( _dlg, SIGNAL(dryrun()), SLOT(dryrun()) );
  connect( _dlg, SIGNAL(merge()), SLOT(merge()) );
  connect( _dlg, SIGNAL(closed()), SLOT(close()) );

  _dlg->enableRepositoryUrl1(_enableSrc1);
  _dlg->enableRepositoryUrl2(src1!=src2);
  _dlg->setRepositoryUrl1(src1);
  _dlg->setRepositoryUrl2(src2);
  _dlg->setRevision1(first);
  _dlg->setRevision2(second);

  // preset the wc combo box with the projects working copies
  Project::Items items;
  _prj->getItems(items);

  for( Project::Items::iterator it = items.begin(); it != items.end(); it++ )
  {
    const Project::Item& item = *it;

    if( item.isWorkingCopy() )
    {
      QString tdst = QString::fromUtf8(item.getSource());
      if( tdst != dst )
      {
        _dlg->setWorkingCopyPath( tdst );
      }
    }
  }
  _dlg->setWorkingCopyPath(dst);

  _dlg->show();
}

void MergeDialogCmd::dryrun()
{
  MergeParam*    param = _dlg->getParameters(true);
  PostCmdResult* pcres = new PostCmdResult(_tid);

  _model->merge( param, pcres );
}

void MergeDialogCmd::merge()
{
  MergeParam*    param = _dlg->getParameters(false);
  PostCmdResult* pcres = new PostCmdResult(_tid);

  _model->merge( param, pcres );
}

void MergeDialogCmd::close()
{
  delete this;
}
