/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REORDERPROJECTSEVENT_H
#define _SC_REORDERPROJECTSEVENT_H

// sc
#include "CustomEvents.h"
class Project;

// qt
#include <qevent.h>


class ReOrderProjectsEvent : public QCustomEvent
{
public:
  ReOrderProjectsEvent( Project* src, Project* dst )
    : QCustomEvent(ScReOrderProjectsEvent), _src(src), _dst(dst)
  {
  }

  Project* getSrc() const
  {
    return _src;
  }

  Project* getDst() const
  {
    return _dst;
  }

private:
  Project* _src;
  Project* _dst;
};

#endif // _SC_REORDERPROJECTSEVENT_H
