/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SUBVERSION_SETTINGS_INFO_H
#define _SC_SUBVERSION_SETTINGS_INFO_H

// sc
#include "sublib/settings/SettingsInfoBase.h"
class SubversionSettings;
class SettingsWidget;

// qt
#include <qstring.h>
#include <qfont.h>


class SubversionSettingsInfo : public SettingsInfoBase
{
public:
  SubversionSettingsInfo( const QString& title, const QString& id,
    SubversionSettings* ss, int sortIndex );
  ~SubversionSettingsInfo();

  const QString& getTitle();
  const QString& getSettingsId();

  void initWidgetData( SettingsWidget* sw );
  void storeWidgetData( SettingsWidget* sw );
  
  bool isModified();

  void ok();
  void apply();
  void cancel();

  int getSortIndex();

private:
  QString             _title;
  QString             _id;

  int                 _sortIndex;

  SubversionSettings* _ss;

  bool                _aspDotNetHack;
};


#endif //  _SC_SUBVERSION_SETTINGS_INFO_H
