/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "MacStyle.h"

#if defined SC_ENABLE_STYLE

// qt
#include <qpainter.h>


MacStyle::MacStyle() : super()
{
}

MacStyle::~MacStyle()
{
}

void MacStyle::drawPrimitive( PrimitiveElement pe, QPainter* p, const QRect& r,
  const QColorGroup& cg, SFlags flags, const QStyleOption& opt ) const
{
  super::drawPrimitive( pe, p, r, cg, flags, opt );
}

void MacStyle::drawComplexControl( ComplexControl control, QPainter* p, const
  QWidget* widget, const QRect& r, const QColorGroup& cg, SFlags how, SCFlags sub,
  SCFlags subActive, const QStyleOption& opt ) const
{
  if( control == CC_ToolButton )
  {
    // doing nothing here keeps Qt from drawing frames for tool bar buttons.
    // That heavily improves the look on MacOSX. 
  }
  else
  {
    super::drawComplexControl(control,p,widget,r,cg,how,sub,subActive,opt);
  }
}

#endif // SC_ENABLE_STYLE
