/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */
#ifndef _SC_MACSTYLE_H
#define _SC_MACSTYLE_H


// qt
#include <qglobal.h>

#if defined(Q_OS_MACX)

#include <qmacstyle_mac.h>
typedef QMacStyle QBaseStyle;
#define SC_ENABLE_STYLE 1

#elif defined(Q_OS_WIN32)

#include <qwindowsstyle.h>
typedef QWindowsStyle QBaseStyle;
#define SC_ENABLE_STYLE 1

#endif


/**
 * Subcommander specific style modifications.
 * \todo rename to ScStyle
 */
#if defined SC_ENABLE_STYLE
class MacStyle : public QBaseStyle
{
  typedef QBaseStyle super;

public:
  MacStyle();
  ~MacStyle();
  
  void drawPrimitive( PrimitiveElement pe, QPainter* p, const QRect& r,
    const QColorGroup & cg, SFlags flags = Style_Default, const QStyleOption& =
    QStyleOption::Default ) const;

  void drawComplexControl( ComplexControl control, QPainter* p, const QWidget*
    widget, const QRect& r, const QColorGroup& cg, SFlags how = Style_Default,
    SCFlags sub = SC_None, SCFlags subActive = SC_None, const QStyleOption& opt =
                           QStyleOption::Default ) const;
  
private:
  // disable..
  MacStyle( const MacStyle & );
  MacStyle& operator=( const MacStyle & );
};
#endif // SC_ENABLE_STYLE


#endif // _SC_MACSTYLE_H
