/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "Property.h"

// svn
#include <svn_client.h>


namespace svn
{

Property::Property( svn_prop_t* prop )
{
  _name  = sc::String(prop->name);
  _value = sc::String(prop->value->data,prop->value->len);
}

const sc::String& Property::getName() const
{
  return _name;
}

const sc::String& Property::getValue() const
{
  return _value;
}

bool Property::needsTranslation() const
{
  return needsTranslation(_name);
}

bool Property::needsTranslation( const sc::String& prop )
{
  return svn_prop_needs_translation( prop.getStr() ) != 0;
}


} // namespace
