//
// C++ Interface: accesspointlistview
//
// Description: 
//
//
// Author: Ivn Forcada Atienza <ivan@swscanner.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ACCESSPOINTLISTVIEW_H
#define ACCESSPOINTLISTVIEW_H

#include <qlistview.h>
#include <qheader.h>
#include <qvariant.h>
#include <qfile.h>
#include <qcheckbox.h>
#include <qmutex.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kmainwindow.h>

#include "apentry.h"
#include "treefilterlistview.h"
#include "aplist.h"
#include "swsglobals.h"


/**
@author Ivn Forcada Atienza
*/

QPixmap getPix(int signal);

class AccessPointListView : public QListView
{
private:
	
	QListView *	lstFilter;
	bool		preserve;
	bool		soundEnabled;


public:
	AccessPointListView(QWidget * parent = 0, const char * name = 0, WFlags f = 0);
	~AccessPointListView() {} ;

	void	setPreserve(bool b) { preserve = b; };
	void	setSoundEnabled(bool b) { soundEnabled = b; };

	int	getCol(QString title);
	bool 	getSelectedWEP();
	QString getSelectedESSID();
	QString getSelectedMAC();

	void	addNewAP(APEntry* ap);
	void	repaintTable();

	uint	visiblesCount();

	int	aplistFromTable(APList *);

	static	QString	getVendor(QString MAC);

private:
	void		updateRow(APEntry* ap);
	void		addNewRow(APEntry* ap);
	void		addNewRow(QListViewItem* row);
	void		adjustColumns();
	bool		IsInTable(QString MAC);
	bool		IsInTree (QListViewItem * parentNode, QString strToFind);
	QListView *	Filter();

};

#endif
