//
// C++ Implementation: frmsignalchart
//
// Description: 
//
//
// Author: Ivn Forcada Ateinza <ivan@swscanner.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "frmsignalchart.h"

frmSignalChart::frmSignalChart( QString mac, QWidget *parent, const char *name, bool modal)
 		:KDialogBase( parent, name, modal, QString::null, Cancel|User1, Cancel )
{
	qDebug("Creating frmSignalChart...");
        dlgwidget = new dlgSignalChart(this); 
	dlgwidget->lblMAC->setText(mac);
	
	int fl = getWFlags() & ~Qt::WStyle_Mask | Qt::WDestructiveClose;
	reparent( parent, fl , this->geometry().topLeft(), FALSE);

	setButtonGuiItem(User1, KGuiItem(i18n("Clear"), "eraser"));
	
	this->setCaption(i18n("Signal/Noise Levels ") + "(" + mac + ")");
	this->setMainWidget(dlgwidget);
}

frmSignalChart::~frmSignalChart()
{
	qDebug("Deleting frmSignalChart...");
	delete dlgwidget;
}

// Handle custom events.
void frmSignalChart::customEvent( QCustomEvent * e )
{
	char essid[33];
	if ( e->type() == (QEvent::Type) newSignalDataReceivedEventNum ) { 
		qDebug("New Signal/Noise data received!!");
		newSignalDataReceivedEvent * ev = (newSignalDataReceivedEvent *)e;
		dlgwidget->signalLed->toggle();
		if (ev->getAccessPoint() == 0) {
			dlgwidget->lblSignal->setText("--");
			dlgwidget->lblNoise->setText("--");
			dlgwidget->lblSigNoi->setText("--");
			signal.append(0);
			noise.append(0);
			signoi.append(0);
		} else {
			dlgwidget->lblESSID->setText(ev->getAccessPoint()->getEssid(essid));			
			dlgwidget->lblSignal->setText(QVariant(ev->getAccessPoint()->getSignal()).toString());
			dlgwidget->lblNoise->setText(QVariant(ev->getAccessPoint()->getNoise()).toString());
			dlgwidget->lblSigNoi->setText(QVariant(ev->getAccessPoint()->getSignal() - ev->getAccessPoint()->getNoise()).toString());
			signal.append(ev->getAccessPoint()->getSignal());
			noise.append(ev->getAccessPoint()->getNoise());
			signoi.append(ev->getAccessPoint()->getSignal() - ev->getAccessPoint()->getNoise());
		}
		this->update(); // Call to paintEvent()
	}
}

void frmSignalChart::slotUser1()
{
	setMinimumHeight(0);
	flushData();
}

void frmSignalChart::flushData()
{
	signal.clear();
	noise.clear();
	signoi.clear();
}
void frmSignalChart::paintEvent( QPaintEvent *)
{
	QPainter p;
	QPen pen;
	QRect r = dlgwidget->geometry();
	unsigned int maxpoints = 100;
	int offset = dlgwidget->lblMAC->height() + dlgwidget->lblESSID->height() + 40;
	
	// Refering to the background:
	QPoint topLeft(1, offset);
	QPoint bottomRight(r.bottomRight().x()-11, r.bottomRight().y()-10);
	float scaleX = bottomRight.x() - topLeft.x(); // width pixels
	float scaleY = bottomRight.y() - topLeft.y(); // heigth pixels
	int maxY=-1000, minY=1000;
	float divY=0.0, divX=0.0;
	int i=0;
	
	// signal & noise have the same count() so:
	while (signal.count() > maxpoints) {
		signal.pop_front();
		noise.pop_front();
		signoi.pop_front();
	}
	
	// Update de max/min values of signal/noise
	QValueList<int>::iterator it;
    	for ( it = signal.begin(); it != signal.end(); ++it ) {
		if ((*it) > maxY) maxY=(*it);
		if ((*it) < minY) minY=(*it);
	}	
			
    	for ( it = noise.begin(); it != noise.end(); ++it ) {
		if ((*it) > maxY) maxY=(*it);
		if ((*it) < minY) minY=(*it);
	}	
    	
	for ( it = signoi.begin(); it != signoi.end(); ++it ) {
		if ((*it) > maxY) maxY=(*it);
		if ((*it) < minY) minY=(*it);
	}	
	 	
	maxY += 10; // Never reach the edges!!
 	minY -= 10;
	divY = scaleY/(maxY-minY);
	divX = scaleX/(maxpoints);  

	// Avoid lines colapse
	if (divY < 1 && divY > -1) 
		//setMinimumHeight(abs(int(height()/divY)));
		setMinimumHeight(maxY-minY+offset+80);
	
	p.begin( dlgwidget );
	pen.setColor( black );
	pen.setWidth(2); 
	p.setPen(pen); 
        p.setBrush( QColor(30,30,30) );
	
	p.drawRect(topLeft.x(), topLeft.y(), bottomRight.x(), bottomRight.y() - offset);
		
	// Noise:
        if (dlgwidget->chkNoise->isChecked()) {
		p.moveTo(topLeft.x(), bottomRight.y());
		pen.setColor ( red );
		p.setPen(pen); 
		i=0;
		for ( it = noise.begin(); it != noise.end(); ++it ) {
			p.lineTo(QPoint(topLeft.x() + (int)(i*divX), bottomRight.y() - (int)(divY*((*it) - minY))));
			i++;
		}	
		p.drawText(p.pos(), dlgwidget->lblNoise->text());
	}
	
	// Signal:
	if (dlgwidget->chkSignal->isChecked()) {	
		i=0;
		p.moveTo(topLeft.x(), bottomRight.y());
		pen.setColor ( green );
		p.setPen(pen); 
		for ( it = signal.begin(); it != signal.end(); ++it ) {
			p.lineTo(QPoint(topLeft.x() + (int)(i*divX), bottomRight.y() - (int)(divY*((*it) - minY))));
			i++;
		}
		p.drawText(p.pos(), dlgwidget->lblSignal->text());
	}
		
	// Signal/Noise
	if (dlgwidget->chkSigNoi->isChecked()) {
		i=0;
		p.moveTo(topLeft.x(), bottomRight.y());
		pen.setColor ( blue );
		p.setPen(pen); 
		for ( it = signoi.begin(); it != signoi.end(); ++it ) {
			p.lineTo(QPoint(topLeft.x() + (int)(i*divX), bottomRight.y() - (int)(divY*((*it) - minY))));
			i++;
		}
		p.drawText(p.pos(), QVariant(signoi.last()).toString());
	}
		
	p.setBrush( NoBrush );
	pen.setColor( black );
	p.setPen(pen); 
	p.drawRect(topLeft.x(), topLeft.y(), bottomRight.x(), bottomRight.y() - offset);
	p.end();   
}
