//
// C++ Interface: swsystemtray
//
// Description: 
//
//
// Author: Ivn Forcada Atienza <ivan@swscanner.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SWSYSTEMTRAY_H
#define SWSYSTEMTRAY_H

#include <kxmlguiclient.h>
#include <ksystemtray.h>
#include <kpopupmenu.h>
#include <kaction.h>
#include <klocale.h>

#include <qstringlist.h>

#include "accesspointlistview.h"
#include "configpopupmenu.h"

/**
@author Ivn Forcada Atienza
*/

// Class created only to re-implement the contextMenuAboutToShow() function
class SWSystemTray : public KSystemTray
{
Q_OBJECT

private:
	QString			iface;
	AccessPointListView* 	table;
	KPopupMenu* 		aplist;

public:
	SWSystemTray(QString iface, QWidget *parent=0, const char *name=0);
	~SWSystemTray();

	void setIface(QString ifc) { iface = ifc; }; 
	void clearApList() { aplist->clear(); };
	
public slots:
	virtual void contextMenuAboutToShow(KPopupMenu * );
	virtual void itemHighlighted(int);
	
private:
	int getMenuId(KPopupMenu *, QString name);
};

#endif
