/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "discover.h"
#include "utils.h"


struct joystick_info *joystick_detect(struct bus_lst *bus){
  struct joystick_info *result = (struct joystick_info *)NULL;
  struct usb_info *usb = (struct usb_info *)NULL;
  static struct joystick_info *first = (struct joystick_info *)NULL;

  if(first){
    return first;
  }/*endif*/
  
  if(debug){
    fprintf(stdout, "\nProbing joystick...\n");
  }/*endif*/
  
  /********************************************************************/
  /************************* USB JOYSTICK  ****************************/
  /********************************************************************/
  if(debug){
    fprintf(stdout, "\tProbing USB joystick...\n");
  }/*endif*/
  for(usb = bus->usb; usb; usb = usb->next){
    if(usb->type == JOYSTICK){
      if(!first){
        first = result = (struct joystick_info *)
                                my_malloc(sizeof(struct joystick_info));
      }else{
        result->next = (struct joystick_info *)
                                my_malloc(sizeof(struct joystick_info));
         result = result->next;
      }/*endif*/
      result->next = (struct joystick_info *)NULL;
      result->vendor = usb->vendor;
      result->model = usb->model;
      result->module = usb->modulename;
      result->device = s_not_available;
      result->bus = USB;
      if(debug){
         fprintf(stdout, "\t\tFound %s", result->model);
      }/*endif*/
    }/*endif*/
  }/*next usb*/
  return first;
}/*endfunc joystick_detect*/


extern struct gameport_info *gameport_detect(struct bus_lst *bus){
  struct isa_info *isa = (struct isa_info *)NULL;
  struct pci_info *pci = (struct pci_info *)NULL;
  static struct gameport_info *first = (struct gameport_info *)NULL;
  struct gameport_info *result = (struct gameport_info *)NULL;

  if(first){
    return first;
  }/*endif*/
  
  if(debug){
    fprintf(stdout, "\nProbing Game Port...\n");
  }/*endif*/
  
  /********************************************************************/
  /*********************** GAMEPORT DETECTION *************************/
  /********************************************************************/

  /* joystick == gameport for ISA device, because we can't say if a   */
  /* joystick is connected or not.                                    */
  if(debug){
    fprintf(stdout, "\tProbing ISA Game Port...\n");
  }/*endif*/
  for(isa = bus->isa; isa; isa = isa->next){
    if(isa->type == JOYSTICK){
      if(!first){
        first = result = (struct gameport_info *)
                                my_malloc(sizeof(struct gameport_info));
      }else{
        result->next = (struct gameport_info *)
                                my_malloc(sizeof(struct gameport_info));
        result = result->next;
      }/*endif*/
      result->next = (struct gameport_info *)NULL;
      result->vendor = isa->vendor;
      result->model = isa->model;
      result->io = isa->io;
      result->irq = isa->irq;
      if(debug){
        fprintf(stdout, "\t\tFound %s %s\n",
                                         result->vendor, result->model);
      }/*endif*/
    }/*endif*/
  }/*next isa*/
  

  /* joystick == gameport for PCI device, because we can't say if a   */
  /* joystick is connected or not.                                    */
  if(debug){
    fprintf(stdout, "\tProbing PCI Game Port...\n");
  }/*endif*/
  for(pci = bus->pci; pci; pci = pci->next){
    if(pci->type == JOYSTICK){
      if(!first){
        first = result = (struct gameport_info *)
                                my_malloc(sizeof(struct gameport_info));
      }else{
        result->next = (struct gameport_info *)
                                my_malloc(sizeof(struct gameport_info));
        result = result->next;
      }/*endif*/
      result->next = (struct gameport_info *)NULL;
      
      result->vendor = pci->vendor;
      result->model = pci->model;
      if(debug){
        fprintf(stdout, "\t\tFound %s %s\n", 
                                         result->vendor, result->model);
      }/*endif*/
    }/*endif*/
  }/*next pci*/

  return first;
}/*endfunc gameport_detect*/

