#ifndef CONSOLE_H
#define CONSOLE_H

#define prepareConsole udpc_prepareConsole
#define getConsoleFd udpc_getConsoleFd
#define restoreConsole udpc_restoreConsole

typedef struct console_t console_t;

/**
 * Prepares a console on given fd. If fd = -1, opens /dev/tty instead
 */
console_t *prepareConsole(int fd);

/**
 * Returns file descriptor for console
 */
int getConsoleFd(console_t **);

/**
 * Restores console into its original state, and restores everything as it was
 * before
 */
void restoreConsole(console_t **, int);

#endif
