/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: preferred.c,v 1.6 2004/10/17 09:37:05 avian Exp $ */

/* 
 * AUTHOR:
 *
 *  Tomaz Solc <tomaz.solc@siol.net>
 *
 *  Ideas taken from a patch for Tablix 0.0.3 by 
 *  Jaume Obrador <obrador@espaiweb.net>
 *
 * DESCRIPTION:
 *
 *  Adds a weight whenever a tuple (or a group of tuples if perweek is greater
 *  than 1) is not scheduled at the specified preferred day and/or period.
 *
 * DEFINED TUPLE RESTRICTIONS:
 *
 *  <restriction type="preferred-period">period</restriction>
 *
 *  <restriction type="preferred-day">day</restriction>
 *
 *  These two restrictions specify the preferred period and day for a tuple.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>

#include "modsup.h"
#include "data.h"
#include "gettext.h"

int *pperiod;
int *pday;

int getday(char *type, char *cont, int tid)
{
	int p,c;
	
	c=sscanf(cont, "%d", &p);

	if(c<1||p<0||p>days) {
		strcpy(moderror, _("invalid preferred day"));
		return(1);
	}

	pday[tid]=p;

	return 0;
}

int getperiod(char *type, char *cont, int tid)
{
	int p,c;
	
	c=sscanf(cont, "%d", &p);

	if(c<1||p<0||p>periods) {
		strcpy(moderror, _("invalid preferred period"));
		return(1);
	}

	pperiod[tid]=p;

	return 0;
}

parop tuple_restrictions[] = { 
	{ type : "preferred-period", parfunc: getperiod },
	{ type : "preferred-day", parfunc: getday },
	{ type : 0, parfunc: 0 }
};

int init_mod()
{
	int c;

	pperiod=malloc(sizeof(*pperiod)*tuplenum);
	pday=malloc(sizeof(*pday)*tuplenum);

	for(c=0;c<tuplenum;c++) {
		pperiod[c]=-1;
		pday[c]=-1;
	}
	
	return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int c;
	int sum;
	int d,p;

	sum=0;

        for(c=0;c<tuplenum;c++) {
		if(pday[c]>-1) {
			d=t->inf[c].time/periods;
			if(d!=pday[c]) sum++;
		}
		if(pperiod[c]>-1) {
			p=t->inf[c].time%periods;
			if(p!=pperiod[c]) sum++;
		}
	}

	return(sum);
}
