/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002-2004 Tomaz Solc                                      */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: teacher_perday.c,v 1.7 2004/10/17 09:37:05 avian Exp $ */

/* 
 * AUTHOR:
 *  
 *  Tomaz Solc <tomaz.solc@siol.net>
 *
 * DESCRIPTION:
 *
 *  Calculates weekly dispersion of non-free periods for teachers. Number of 
 *  added weights is equal to the sum of dispersions for all teachers.
 *
 *  See student_perday.so module for an explanation of weekly dispersion.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include "data.h"
#include "gettext.h"

int *perday;

int precalc_mod()
{
	int c;
	perday=malloc(sizeof(*perday)*tmapnum);

	for(c=0;c<tmapnum;c++) perday[c]=0;

	for(c=0;c<tuplenum;c++) {
		perday[tuplemap[c].tid]++;
	}

	for(c=0;c<tmapnum;c++) perday[c]=perday[c]/DAYS;

	return(0);
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int a,b,c,d,e;
	int sum;

	sum=0;
        for(c=0;c<tmapnum;c++) {
                for(a=0;a<DAYS;a++) {
			e=0;
                        b=0;
                        while (b<PERIODS) {
                                if (tpnt[b+a*PERIODS]!=-1) e++;
                                b++;
                        }

			e=e-perday[c];

			sum=sum+e*e;
		}

                tpnt+=TIMES;
        };
	return(sum);
	      
}
