/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 * @author  Marcio Macedo <marcio.macedo@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_HANDLE_FACTORY_H__
#define __TPA_HANDLE_FACTORY_H__

#include <glib.h>
#include <glib-object.h>

#include "tpa-handle.h"
#include <tapioca/client/tpa-object.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_HANDLE_FACTORY \
    (tpa_handle_factory_get_type())
#define TPA_HANDLE_FACTORY(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_HANDLE_FACTORY, TpaHandleFactory))
#define TPA_HANDLE_FACTORY_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_HANDLE_FACTORY, TpaHandleFactoryClass))
#define TPA_IS_HANDLE_FACTORY(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_HANDLE_FACTORY))
#define TPA_IS_HANDLE_FACTORY_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_HANDLE_FACTORY))
#define TPA_HANDLE_FACTORY_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_HANDLE_FACTORY, TpaHandleFactoryClass))
#define TPA_HANDLE_FACTORY_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_HANDLE_FACTORY, TpaHandleFactoryPrivate))


typedef struct _TpaHandleFactory TpaHandleFactory;
typedef struct _TpaHandleFactoryClass TpaHandleFactoryClass;
typedef struct _TpaHandleFactoryPrivate TpaHandleFactoryPrivate;

struct _TpaHandleFactoryClass {
    TpaObjectClass parent_class;
};

struct _TpaHandleFactory {
    TpaObject parent;
    TpaHandleFactoryPrivate *priv;
};

TpaHandle*          tpa_handle_factory_create_handle            (TpaHandleFactory *self,
                                                                 TpaHandleType type,
                                                                 const gchar* name);
TpaHandle*          tpa_handle_factory_create_handle_by_id      (TpaHandleFactory *self,
                                                                 TpaHandleType type,
                                                                 guint id);

G_END_DECLS

#endif /* #ifndef __TPA_HANDLE_FACTORY_H__*/
