/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_HANDLE_H__
#define __TPA_HANDLE_H__

#include "tpa-enums.h"

#include <glib.h>
#include <glib-object.h>

#include <dbus/dbus-glib-bindings.h>

#include <tapioca/client/tpa-object.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_HANDLE \
    (tpa_handle_get_type())
#define TPA_HANDLE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_HANDLE, TpaHandle))
#define TPA_HANDLE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_HANDLE, TpaHandleClass))
#define TPA_IS_HANDLE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_HANDLE))
#define TPA_IS_HANDLE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_HANDLE))
#define TPA_HANDLE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_HANDLE, TpaHandleClass))
#define TPA_HANDLE_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_HANDLE, TpaHandlePrivate))


typedef struct _TpaHandle TpaHandle;
typedef struct _TpaHandleClass TpaHandleClass;
typedef struct _TpaHandlePrivate TpaHandlePrivate;

struct _TpaHandleClass {
    TpaObjectClass parent_class;
};

struct _TpaHandle {
    TpaObject parent;
    TpaHandlePrivate *priv;
};

GType               tpa_handle_get_type                 (void);
TpaHandle *         tpa_handle_new                      (TpaObject *object,
                                                         TpaHandleType type,
                                                         const gchar *name);
TpaHandle *         tpa_handle_new_by_id                (TpaObject *object,
                                                         TpaHandleType type,
                                                         guint id);
const gchar *       tpa_handle_get_name                 (TpaHandle *self);
guint               tpa_handle_get_id                   (TpaHandle *self);
TpaHandleType       tpa_handle_get_handle_type          (TpaHandle *self);
void                tpa_handle_hold                     (TpaHandle *self);

G_END_DECLS

#endif /* #ifndef __TPA_HANDLE_H__*/
