/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_MANAGER_PRIV_H__
#define __TPA_MANAGER_PRIV_H__

G_BEGIN_DECLS

TpaManager *        tpa_manager_new_from_file           (const gchar *file);
TpaManager *        tpa_manager_new_from_bus            (const gchar *service_name,
                                                         const gchar *object_path,
                                                         const gchar **services);
TpaProfile *        tpa_manager_add_profile             (TpaManager *self,
                                                         const gchar *file);
G_END_DECLS

#endif /* #ifndef __TPA_MANAGER_PRIV_H__*/
