/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_STREAM_CHANNEL_H__
#define __TPA_STREAM_CHANNEL_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-channel.h>
#include <tapioca/client/tpa-stream.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_STREAM_CHANNEL \
    (tpa_stream_channel_get_type())
#define TPA_STREAM_CHANNEL(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_STREAM_CHANNEL, TpaStreamChannel))
#define TPA_STREAM_CHANNEL_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_STREAM_CHANNEL, TpaStreamChannelClass))
#define TPA_IS_STREAM_CHANNEL(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_STREAM_CHANNEL))
#define TPA_IS_STREAM_CHANNEL_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_STREAM_CHANNEL))
#define TPA_STREAM_CHANNEL_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_STREAM_CHANNEL, TpaStreamChannelClass))
#define TPA_STREAM_CHANNEL_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_STREAM_CHANNEL, TpaStreamChannelPrivate))


typedef struct _TpaStreamChannel TpaStreamChannel;
typedef struct _TpaStreamChannelClass TpaStreamChannelClass;
typedef struct _TpaStreamChannelPrivate TpaStreamChannelPrivate;

struct _TpaStreamChannelClass {
    TpaChannelClass parent_class;
};

struct _TpaStreamChannel {
    TpaChannel parent;
    TpaStreamChannelPrivate *priv;
};

GType                        tpa_stream_channel_get_type         (void);
void                         tpa_stream_channel_join             (TpaStreamChannel *self);
void                         tpa_stream_channel_request_streams  (TpaStreamChannel *self,
                                                                  const TpaContact *contact,
                                                                  GList *type_list);
void                         tpa_stream_channel_remove_stream    (TpaStreamChannel *self,
                                                                  TpaStream *stream);
G_CONST_RETURN GList *       tpa_stream_channel_get_streams      (TpaStreamChannel *self);



G_END_DECLS

#endif /* #ifndef __TPA_STREAM_CHANNEL_H__*/

