/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_TEXT_MESSAGE_H__
#define __TPA_TEXT_MESSAGE_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-enums.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_TEXT_MESSAGE \
    (tpa_text_message_get_type())
#define TPA_TEXT_MESSAGE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_TEXT_MESSAGE, TpaTextMessage))
#define TPA_TEXT_MESSAGE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_TEXT_MESSAGE, TpaTextMessageClass))
#define TPA_IS_TEXT_MESSAGE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_TEXT_MESSAGE))
#define TPA_IS_TEXT_MESSAGE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_TEXT_MESSAGE))
#define TPA_TEXT_MESSAGE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_TEXT_MESSAGE, TpaTextMessageClass))
#define TPA_TEXT_MESSAGE_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_TEXT_MESSAGE, TpaTextMessagePrivate))


typedef struct _TpaTextMessage TpaTextMessage;
typedef struct _TpaTextMessageClass TpaTextMessageClass;
typedef struct _TpaTextMessagePrivate TpaTextMessagePrivate;

struct _TpaTextMessageClass {
    GObjectClass parent_class;
};

struct _TpaTextMessage {
    GObject parent;
    TpaTextMessagePrivate *priv;
};

GType               tpa_text_message_get_type               (void);
TpaTextMessage *    tpa_text_message_new                    (guint id,
                                                             const gchar *uri,
                                                             const gchar *contents,
                                                             guint timestamp,
                                                             TpaTextMessageType type);
guint               tpa_text_message_get_id                 (TpaTextMessage *self);
const gchar *       tpa_text_message_get_uri                (TpaTextMessage *self);
const gchar *       tpa_text_message_get_contents           (TpaTextMessage *self);
guint               tpa_text_message_get_time_stamp         (TpaTextMessage *self);
TpaTextMessageType  tpa_text_message_type                   (TpaTextMessage *self);

G_END_DECLS

#endif /* #ifndef __TPA_TEXT_MESSAGE_H__*/
